/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.sampler;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.CollectionTerminatedException;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.LeafCollector;
import conductor.org.apache.lucene.search.ScoreDoc;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.TopDocs;
import conductor.org.apache.lucene.search.TopDocsCollector;
import conductor.org.apache.lucene.search.TopScoreDocCollector;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.lease.Releasable;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.ObjectArray;
import conductor.org.elasticsearch.search.aggregations.BucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.MultiBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BestDocsDeferringCollector
extends DeferringBucketCollector
implements Releasable {
    private final List<PerSegmentCollects> entries = new ArrayList<PerSegmentCollects>();
    private BucketCollector deferred;
    private ObjectArray<PerParentBucketSamples> perBucketSamples;
    private int shardSize;
    private PerSegmentCollects perSegCollector;
    private final BigArrays bigArrays;

    BestDocsDeferringCollector(int shardSize, BigArrays bigArrays) {
        this.shardSize = shardSize;
        this.bigArrays = bigArrays;
        this.perBucketSamples = bigArrays.newObjectArray(1L);
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.deferred = MultiBucketCollector.wrap(deferredCollectors);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx) throws IOException {
        this.perSegCollector = new PerSegmentCollects(ctx);
        this.entries.add(this.perSegCollector);
        return new LeafBucketCollector(){

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                BestDocsDeferringCollector.this.perSegCollector.setScorer(scorer);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                BestDocsDeferringCollector.this.perSegCollector.collect(doc, bucket);
            }
        };
    }

    protected TopDocsCollector<? extends ScoreDoc> createTopDocsCollector(int size) throws IOException {
        return TopScoreDocCollector.create(size);
    }

    @Override
    public void preCollection() throws IOException {
        this.deferred.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.runDeferredAggs();
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
    }

    private void runDeferredAggs() throws IOException {
        ArrayList<ScoreDoc> allDocs = new ArrayList<ScoreDoc>(this.shardSize);
        int i = 0;
        while ((long)i < this.perBucketSamples.size()) {
            PerParentBucketSamples perBucketSample = this.perBucketSamples.get(i);
            if (perBucketSample != null) {
                perBucketSample.getMatches(allDocs);
            }
            ++i;
        }
        ScoreDoc[] docsArr = allDocs.toArray(new ScoreDoc[allDocs.size()]);
        Arrays.sort(docsArr, (o1, o2) -> {
            if (o1.doc == o2.doc) {
                return o1.shardIndex - o2.shardIndex;
            }
            return o1.doc - o2.doc;
        });
        try {
            for (PerSegmentCollects perSegDocs : this.entries) {
                perSegDocs.replayRelatedMatches(docsArr);
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("IOException collecting best scoring results", (Throwable)e, new Object[0]);
        }
        this.deferred.postCollection();
    }

    public int getDocCount(long parentBucket) {
        PerParentBucketSamples sampler = this.perBucketSamples.get((int)parentBucket);
        if (sampler == null) {
            return 0;
        }
        return sampler.getDocCount();
    }

    @Override
    public void close() throws ElasticsearchException {
        Releasables.close(this.perBucketSamples);
    }

    class PerSegmentCollects
    extends Scorer {
        private LeafReaderContext readerContext;
        int maxDocId;
        private float currentScore;
        private int currentDocId;
        private Scorer currentScorer;

        PerSegmentCollects(LeafReaderContext readerContext) throws IOException {
            super(null);
            this.maxDocId = Integer.MIN_VALUE;
            this.currentDocId = -1;
            this.readerContext = readerContext;
            int i = 0;
            while ((long)i < BestDocsDeferringCollector.this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = (PerParentBucketSamples)BestDocsDeferringCollector.this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.changeSegment(readerContext);
                }
                ++i;
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.currentScorer = scorer;
            int i = 0;
            while ((long)i < BestDocsDeferringCollector.this.perBucketSamples.size()) {
                PerParentBucketSamples perBucketSample = (PerParentBucketSamples)BestDocsDeferringCollector.this.perBucketSamples.get(i);
                if (perBucketSample != null) {
                    perBucketSample.setScorer(scorer);
                }
                ++i;
            }
        }

        public void replayRelatedMatches(ScoreDoc[] sd) throws IOException {
            try {
                LeafBucketCollector leafCollector = BestDocsDeferringCollector.this.deferred.getLeafCollector(this.readerContext);
                leafCollector.setScorer(this);
                this.currentScore = 0.0f;
                this.currentDocId = -1;
                if (this.maxDocId < 0) {
                    return;
                }
                for (ScoreDoc scoreDoc : sd) {
                    int rebased = scoreDoc.doc - this.readerContext.docBase;
                    if (rebased < 0 || rebased > this.maxDocId) continue;
                    this.currentScore = scoreDoc.score;
                    this.currentDocId = rebased;
                    leafCollector.collect(rebased, scoreDoc.shardIndex);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public int docID() {
            return this.currentDocId;
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new ElasticsearchException("This caching scorer implementation only implements score() and docID()", new Object[0]);
        }

        public void collect(int docId, long parentBucket) throws IOException {
            BestDocsDeferringCollector.this.perBucketSamples = BestDocsDeferringCollector.this.bigArrays.grow(BestDocsDeferringCollector.this.perBucketSamples, parentBucket + 1L);
            PerParentBucketSamples sampler = (PerParentBucketSamples)BestDocsDeferringCollector.this.perBucketSamples.get((int)parentBucket);
            if (sampler == null) {
                sampler = new PerParentBucketSamples(parentBucket, this.currentScorer, this.readerContext);
                BestDocsDeferringCollector.this.perBucketSamples.set((int)parentBucket, sampler);
            }
            sampler.collect(docId);
            this.maxDocId = Math.max(this.maxDocId, docId);
        }
    }

    class PerParentBucketSamples {
        private LeafCollector currentLeafCollector;
        private TopDocsCollector<? extends ScoreDoc> tdc;
        private long parentBucket;
        private int matchedDocs;

        PerParentBucketSamples(long parentBucket, Scorer scorer, LeafReaderContext readerContext) {
            try {
                this.parentBucket = parentBucket;
                this.tdc = BestDocsDeferringCollector.this.createTopDocsCollector(BestDocsDeferringCollector.this.shardSize);
                this.currentLeafCollector = this.tdc.getLeafCollector(readerContext);
                this.setScorer(scorer);
            }
            catch (IOException e) {
                throw new ElasticsearchException("IO error creating collector", (Throwable)e, new Object[0]);
            }
        }

        public void getMatches(List<ScoreDoc> allDocs) {
            TopDocs topDocs = this.tdc.topDocs();
            ScoreDoc[] sd = topDocs.scoreDocs;
            this.matchedDocs = sd.length;
            for (ScoreDoc scoreDoc : sd) {
                scoreDoc.shardIndex = (int)this.parentBucket;
            }
            allDocs.addAll(Arrays.asList(sd));
        }

        public void collect(int doc) throws IOException {
            this.currentLeafCollector.collect(doc);
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.currentLeafCollector.setScorer(scorer);
        }

        public void changeSegment(LeafReaderContext readerContext) throws IOException {
            this.currentLeafCollector = this.tdc.getLeafCollector(readerContext);
        }

        public int getDocCount() {
            return this.matchedDocs;
        }
    }
}

