/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.bucket.sampler;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.search.DiversifiedTopDocsCollector;
import conductor.org.apache.lucene.search.TopDocsCollector;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BytesRefHash;
import conductor.org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import conductor.org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DiversifiedMapSamplerAggregator
extends SamplerAggregator {
    private ValuesSource valuesSource;
    private int maxDocsPerValue;
    private BytesRefHash bucketOrds;

    DiversifiedMapSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, ValuesSource valuesSource, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.maxDocsPerValue = maxDocsPerValue;
        this.bucketOrds = new BytesRefHash(shardSize, context.bigArrays());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.bucketOrds);
        super.doClose();
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector();
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector() {
            super(DiversifiedMapSamplerAggregator.this.shardSize, DiversifiedMapSamplerAggregator.this.context.bigArrays());
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            return new ValuesDiversifiedTopDocsCollector(size, DiversifiedMapSamplerAggregator.this.maxDocsPerValue);
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedBinaryDocValues values;

            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedMapSamplerAggregator.this.valuesSource.bytesValues(context);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new AbstractNumericDocValues(){
                    private int docID = -1;

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        this.docID = target;
                        if (ValuesDiversifiedTopDocsCollector.this.values.advanceExact(target)) {
                            if (ValuesDiversifiedTopDocsCollector.this.values.docValueCount() > 1) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public long longValue() throws IOException {
                        BytesRef bytes = ValuesDiversifiedTopDocsCollector.this.values.nextValue();
                        long bucketOrdinal = DiversifiedMapSamplerAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                        }
                        return bucketOrdinal;
                    }
                };
            }
        }
    }
}

