/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.mad;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.search.aggregations.AggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactories;
import conductor.org.elasticsearch.search.aggregations.AggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.metrics.mad.MedianAbsoluteDeviationAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValueType;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSourceType;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class MedianAbsoluteDeviationAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource.Numeric, MedianAbsoluteDeviationAggregationBuilder> {
    public static final String NAME = "median_absolute_deviation";
    private static final ParseField COMPRESSION_FIELD = new ParseField("compression", new String[0]);
    private static final ObjectParser<MedianAbsoluteDeviationAggregationBuilder, Void> PARSER = new ObjectParser("median_absolute_deviation");
    private double compression = 1000.0;

    public static MedianAbsoluteDeviationAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new MedianAbsoluteDeviationAggregationBuilder(aggregationName), null);
    }

    public MedianAbsoluteDeviationAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
    }

    public MedianAbsoluteDeviationAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
        this.compression = in.readDouble();
    }

    protected MedianAbsoluteDeviationAggregationBuilder(MedianAbsoluteDeviationAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.compression = clone.compression;
    }

    public double compression() {
        return this.compression;
    }

    public MedianAbsoluteDeviationAggregationBuilder compression(double compression) {
        if (compression <= 0.0) {
            throw new IllegalArgumentException("[" + COMPRESSION_FIELD.getPreferredName() + "] must be greater than 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new MedianAbsoluteDeviationAggregationBuilder(this, factoriesBuilder, metaData);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.compression);
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new MedianAbsoluteDeviationAggregatorFactory(this.name, config, context, parent, subFactoriesBuilder, this.metaData, this.compression);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(COMPRESSION_FIELD.getPreferredName(), this.compression);
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.compression);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        MedianAbsoluteDeviationAggregationBuilder other = (MedianAbsoluteDeviationAggregationBuilder)obj;
        return Objects.equals(this.compression, other.compression);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, false);
        PARSER.declareDouble(MedianAbsoluteDeviationAggregationBuilder::compression, COMPRESSION_FIELD);
    }
}

