/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.aggregations.metrics.mad;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.lease.Releasables;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.common.util.ObjectArray;
import conductor.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import conductor.org.elasticsearch.search.DocValueFormat;
import conductor.org.elasticsearch.search.aggregations.Aggregator;
import conductor.org.elasticsearch.search.aggregations.InternalAggregation;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollector;
import conductor.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import conductor.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import conductor.org.elasticsearch.search.aggregations.metrics.mad.InternalMedianAbsoluteDeviation;
import conductor.org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import conductor.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import conductor.org.elasticsearch.search.aggregations.support.ValuesSource;
import conductor.org.elasticsearch.search.internal.SearchContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MedianAbsoluteDeviationAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private final double compression;
    private ObjectArray<TDigestState> valueSketches;

    MedianAbsoluteDeviationAggregator(String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, @Nullable ValuesSource.Numeric valuesSource, DocValueFormat format, double compression) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = Objects.requireNonNull(format);
        this.compression = compression;
        this.valueSketches = context.bigArrays().newObjectArray(1L);
    }

    private boolean hasDataForBucket(long bucketOrd) {
        return bucketOrd < this.valueSketches.size() && this.valueSketches.get(bucketOrd) != null;
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.hasDataForBucket(owningBucketOrd)) {
            return InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valueSketches.get(owningBucketOrd));
        }
        return Double.NaN;
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                MedianAbsoluteDeviationAggregator.this.valueSketches = bigArrays.grow(MedianAbsoluteDeviationAggregator.this.valueSketches, bucket + 1L);
                TDigestState valueSketch = (TDigestState)MedianAbsoluteDeviationAggregator.this.valueSketches.get(bucket);
                if (valueSketch == null) {
                    valueSketch = new TDigestState(MedianAbsoluteDeviationAggregator.this.compression);
                    MedianAbsoluteDeviationAggregator.this.valueSketches.set(bucket, valueSketch);
                }
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        valueSketch.add(value);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        if (this.hasDataForBucket(bucket)) {
            TDigestState valueSketch = this.valueSketches.get(bucket);
            return new InternalMedianAbsoluteDeviation(this.name, this.pipelineAggregators(), this.metaData(), this.format, valueSketch);
        }
        return this.buildEmptyAggregation();
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMedianAbsoluteDeviation(this.name, this.pipelineAggregators(), this.metaData(), this.format, new TDigestState(this.compression));
    }

    @Override
    public void doClose() {
        Releasables.close(this.valueSketches);
    }
}

