/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.bytes.BytesReference;
import conductor.org.elasticsearch.common.io.stream.BytesStreamOutput;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.search.SearchHit;
import conductor.org.elasticsearch.search.fetch.FetchSubPhase;
import conductor.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.Map;

public final class FetchSourceSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.sourceRequested()) {
            return;
        }
        boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
        SourceLookup source = context.lookup().source();
        FetchSourceContext fetchSourceContext = context.fetchSourceContext();
        assert (fetchSourceContext.fetchSource());
        if (!nestedHit) {
            if (fetchSourceContext.includes().length == 0 && fetchSourceContext.excludes().length == 0) {
                hitContext.hit().sourceRef(source.internalSourceRef());
                return;
            }
            if (source.internalSourceRef() == null) {
                throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.indexShard().shardId().getIndexName() + "]");
            }
        }
        Map<String, Object> value = source.filter(fetchSourceContext);
        if (nestedHit) {
            value = this.getNestedSource(value, hitContext);
        }
        try {
            int initialCapacity = nestedHit ? 1024 : Math.min(1024, source.internalSourceRef().length());
            BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
            XContentBuilder builder = new XContentBuilder(source.sourceContentType().xContent(), streamOutput);
            if (value != null) {
                builder.value(value);
            } else {
                builder.startObject();
                builder.endObject();
            }
            hitContext.hit().sourceRef(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
        }
    }

    private Map<String, Object> getNestedSource(Map<String, Object> sourceAsMap, FetchSubPhase.HitContext hitContext) {
        for (SearchHit.NestedIdentity o = hitContext.hit().getNestedIdentity(); o != null; o = o.getChild()) {
            if ((sourceAsMap = (Map)sourceAsMap.get(o.getField().string())) != null) continue;
            return null;
        }
        return sourceAsMap;
    }
}

