/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.fetch.subphase.highlight;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.TextField;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.IndexableFieldType;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.search.fetch.subphase.highlight.SimpleFragmentsBuilder;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.lookup.SourceLookup;
import java.io.IOException;
import java.util.List;

public class SourceSimpleFragmentsBuilder
extends SimpleFragmentsBuilder {
    private final SearchContext searchContext;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(MappedFieldType fieldType, SearchContext searchContext, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(fieldType, preTags, postTags, boundaryScanner);
        this.searchContext = searchContext;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SourceLookup sourceLookup = this.searchContext.lookup().source();
        sourceLookup.setSegmentAndDocument((LeafReaderContext)reader.getContext(), docId);
        List<Object> values = sourceLookup.extractRawValues(this.fieldType.name());
        if (values.isEmpty()) {
            return EMPTY_FIELDS;
        }
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.fieldType.name(), values.get(i).toString(), (IndexableFieldType)TextField.TYPE_NOT_STORED);
        }
        return fields;
    }
}

