/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.slice;

import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.search.ConstantScoreScorer;
import conductor.org.apache.lucene.search.ConstantScoreWeight;
import conductor.org.apache.lucene.search.DocIdSet;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.DocIdSetBuilder;
import conductor.org.apache.lucene.util.StringHelper;
import conductor.org.elasticsearch.search.slice.SliceQuery;
import java.io.IOException;

public final class TermsSliceQuery
extends SliceQuery {
    public static final int SEED = 7919;

    public TermsSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet disi = TermsSliceQuery.this.build(context.reader());
                DocIdSetIterator leafIt = disi.iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), leafIt);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    private DocIdSet build(LeafReader reader) throws IOException {
        DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc());
        Terms terms = reader.terms(this.getField());
        TermsEnum te = terms.iterator();
        PostingsEnum docsEnum = null;
        BytesRef term = te.next();
        while (term != null) {
            int hashCode = StringHelper.murmurhash3_x86_32(term, 7919);
            if (this.contains(hashCode)) {
                docsEnum = te.postings(docsEnum, 0);
                builder.add(docsEnum);
            }
            term = te.next();
        }
        return builder.build();
    }
}

