/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest;

import conductor.org.apache.lucene.util.CharsRefBuilder;
import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.search.SearchPhase;
import conductor.org.elasticsearch.search.internal.SearchContext;
import conductor.org.elasticsearch.search.suggest.Suggest;
import conductor.org.elasticsearch.search.suggest.Suggester;
import conductor.org.elasticsearch.search.suggest.SuggestionSearchContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class SuggestPhase
implements SearchPhase {
    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        SuggestionSearchContext suggest = context.suggest();
        if (suggest == null) {
            return;
        }
        try {
            CharsRefBuilder spare = new CharsRefBuilder();
            ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>(suggest.suggestions().size());
            for (Map.Entry<String, SuggestionSearchContext.SuggestionContext> entry : suggest.suggestions().entrySet()) {
                SuggestionSearchContext.SuggestionContext suggestion = entry.getValue();
                Suggester<SuggestionSearchContext.SuggestionContext> suggester = suggestion.getSuggester();
                Suggest.Suggestion<Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option>> result = suggester.execute(entry.getKey(), suggestion, context.searcher(), spare);
                if (result == null) continue;
                assert (entry.getKey().equals(result.name));
                suggestions.add(result);
            }
            context.queryResult().suggest(new Suggest(suggestions));
        }
        catch (IOException e) {
            throw new ElasticsearchException("I/O exception during suggest phase", (Throwable)e, new Object[0]);
        }
    }
}

