/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.completion.context;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.search.suggest.document.CompletionQuery;
import conductor.org.apache.lucene.search.suggest.document.ContextQuery;
import conductor.org.apache.lucene.search.suggest.document.ContextSuggestField;
import conductor.org.apache.lucene.util.CharsRef;
import conductor.org.apache.lucene.util.CharsRefBuilder;
import conductor.org.elasticsearch.ElasticsearchParseException;
import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.index.mapper.DocumentMapperParser;
import conductor.org.elasticsearch.index.mapper.ParseContext;
import conductor.org.elasticsearch.search.suggest.completion.context.CategoryContextMapping;
import conductor.org.elasticsearch.search.suggest.completion.context.ContextMapping;
import conductor.org.elasticsearch.search.suggest.completion.context.GeoContextMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContextMappings
implements ToXContent,
Iterable<ContextMapping> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ContextMappings.class));
    private final List<ContextMapping> contextMappings;
    private final Map<String, ContextMapping> contextNameMap;

    public ContextMappings(List<ContextMapping> contextMappings) {
        if (contextMappings.size() > 255) {
            throw new UnsupportedOperationException("Maximum of 10 context types are supported was: " + contextMappings.size());
        }
        this.contextMappings = contextMappings;
        this.contextNameMap = new HashMap<String, ContextMapping>(contextMappings.size());
        for (ContextMapping mapping : contextMappings) {
            this.contextNameMap.put(mapping.name(), mapping);
        }
    }

    public int size() {
        return this.contextMappings.size();
    }

    public ContextMapping get(String name) {
        ContextMapping contextMapping = this.contextNameMap.get(name);
        if (contextMapping == null) {
            ArrayList<String> keys = new ArrayList<String>(this.contextNameMap.keySet());
            Collections.sort(keys);
            throw new IllegalArgumentException("Unknown context name [" + name + "], must be one of " + ((Object)keys).toString());
        }
        return contextMapping;
    }

    public void addField(ParseContext.Document document, String name, String input, int weight, Map<String, Set<String>> contexts) {
        document.add(new TypedContextField(name, input, weight, contexts, document));
    }

    @Override
    public Iterator<ContextMapping> iterator() {
        return this.contextMappings.iterator();
    }

    public ContextQuery toContextQuery(CompletionQuery query, Map<String, List<ContextMapping.InternalQueryContext>> queryContexts) {
        ContextQuery typedContextQuery = new ContextQuery(query);
        boolean hasContext = false;
        if (!queryContexts.isEmpty()) {
            CharsRefBuilder scratch = new CharsRefBuilder();
            scratch.grow(1);
            for (int typeId = 0; typeId < this.contextMappings.size(); ++typeId) {
                scratch.setCharAt(0, (char)typeId);
                scratch.setLength(1);
                ContextMapping mapping = this.contextMappings.get(typeId);
                List<ContextMapping.InternalQueryContext> internalQueryContext = queryContexts.get(mapping.name());
                if (internalQueryContext == null) continue;
                for (ContextMapping.InternalQueryContext context : internalQueryContext) {
                    scratch.append(context.context);
                    typedContextQuery.addContext(scratch.toCharsRef(), context.boost, !context.isPrefix);
                    scratch.setLength(1);
                    hasContext = true;
                }
            }
        }
        if (!hasContext) {
            DEPRECATION_LOGGER.deprecated("The ability to query with no context on a context enabled completion field is deprecated and will be removed in the next major release.", new Object[0]);
        }
        return typedContextQuery;
    }

    public Map<String, Set<String>> getNamedContexts(List<CharSequence> contexts) {
        HashMap<String, Set<String>> contextMap = new HashMap<String, Set<String>>(contexts.size());
        for (CharSequence typedContext : contexts) {
            char typeId = typedContext.charAt(0);
            assert (typeId < this.contextMappings.size()) : "Returned context has invalid type";
            ContextMapping mapping = this.contextMappings.get(typeId);
            HashSet<String> contextEntries = (HashSet<String>)contextMap.get(mapping.name());
            if (contextEntries == null) {
                contextEntries = new HashSet<String>();
                contextMap.put(mapping.name(), contextEntries);
            }
            contextEntries.add(typedContext.subSequence(1, typedContext.length()).toString());
        }
        return contextMap;
    }

    public static ContextMappings load(Object configuration, Version indexVersionCreated) throws ElasticsearchParseException {
        ArrayList<ContextMapping> contextMappings;
        if (configuration instanceof List) {
            contextMappings = new ArrayList();
            List configurations = (List)configuration;
            for (Object contextConfig : configurations) {
                contextMappings.add(ContextMappings.load((Map)contextConfig, indexVersionCreated));
            }
            if (contextMappings.size() == 0) {
                throw new ElasticsearchParseException("expected at least one context mapping", new Object[0]);
            }
        } else if (configuration instanceof Map) {
            contextMappings = Collections.singletonList(ContextMappings.load((Map)configuration, indexVersionCreated));
        } else {
            throw new ElasticsearchParseException("expected a list or an entry of context mapping", new Object[0]);
        }
        return new ContextMappings(contextMappings);
    }

    private static ContextMapping load(Map<String, Object> contextConfig, Version indexVersionCreated) {
        ContextMapping contextMapping;
        String name = ContextMappings.extractRequiredValue(contextConfig, "name");
        String type = ContextMappings.extractRequiredValue(contextConfig, "type");
        switch (ContextMapping.Type.fromString(type)) {
            case CATEGORY: {
                contextMapping = CategoryContextMapping.load(name, contextConfig);
                break;
            }
            case GEO: {
                contextMapping = GeoContextMapping.load(name, contextConfig);
                break;
            }
            default: {
                throw new ElasticsearchParseException("unknown context type[" + type + "]", new Object[0]);
            }
        }
        DocumentMapperParser.checkNoRemainingFields(name, contextConfig, indexVersionCreated);
        return contextMapping;
    }

    private static String extractRequiredValue(Map<String, Object> contextConfig, String paramName) {
        Object paramValue = contextConfig.get(paramName);
        if (paramValue == null) {
            throw new ElasticsearchParseException("missing [" + paramName + "] in context mapping", new Object[0]);
        }
        contextConfig.remove(paramName);
        return paramValue.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (ContextMapping contextMapping : this.contextMappings) {
            builder.startObject();
            contextMapping.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.contextMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContextMappings)) {
            return false;
        }
        ContextMappings other = (ContextMappings)obj;
        return this.contextMappings.equals(other.contextMappings);
    }

    private class TypedContextField
    extends ContextSuggestField {
        private final Map<String, Set<String>> contexts;
        private final ParseContext.Document document;

        TypedContextField(String name, String value, int weight, Map<String, Set<String>> contexts, ParseContext.Document document) {
            super(name, value, weight, new CharSequence[0]);
            this.contexts = contexts;
            this.document = document;
        }

        @Override
        protected Iterable<CharSequence> contexts() {
            HashSet<CharsRef> typedContexts = new HashSet<CharsRef>();
            CharsRefBuilder scratch = new CharsRefBuilder();
            scratch.grow(1);
            for (int typeId = 0; typeId < ContextMappings.this.contextMappings.size(); ++typeId) {
                scratch.setCharAt(0, (char)typeId);
                scratch.setLength(1);
                ContextMapping mapping = (ContextMapping)ContextMappings.this.contextMappings.get(typeId);
                HashSet<String> contexts = new HashSet<String>(mapping.parseContext(this.document));
                if (this.contexts.get(mapping.name()) != null) {
                    contexts.addAll((Collection<String>)this.contexts.get(mapping.name()));
                }
                for (String context : contexts) {
                    scratch.append(context);
                    typedContexts.add(scratch.toCharsRef());
                    scratch.setLength(1);
                }
            }
            if (typedContexts.isEmpty()) {
                DEPRECATION_LOGGER.deprecated("The ability to index a suggestion with no context on a context enabled completion field is deprecated and will be removed in the next major release.", new Object[0]);
            }
            return new ArrayList<CharSequence>(typedContexts);
        }
    }
}

