/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.phrase;

import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import conductor.org.elasticsearch.search.suggest.phrase.WordScorer;
import java.util.Arrays;

public final class Correction
implements Comparable<Correction> {
    public static final Correction[] EMPTY = new Correction[0];
    public double score;
    public final DirectCandidateGenerator.Candidate[] candidates;

    public Correction(double score, DirectCandidateGenerator.Candidate[] candidates) {
        this.score = score;
        this.candidates = candidates;
    }

    public String toString() {
        return "Correction [score=" + this.score + ", candidates=" + Arrays.toString(this.candidates) + "]";
    }

    public BytesRef join(BytesRef separator) {
        return this.join(separator, null, null);
    }

    public BytesRef join(BytesRef separator, BytesRef preTag, BytesRef postTag) {
        return this.join(separator, new BytesRefBuilder(), preTag, postTag);
    }

    public BytesRef join(BytesRef separator, BytesRefBuilder result, BytesRef preTag, BytesRef postTag) {
        BytesRef[] toJoin = new BytesRef[this.candidates.length];
        int len = separator.length * this.candidates.length - 1;
        for (int i = 0; i < toJoin.length; ++i) {
            DirectCandidateGenerator.Candidate candidate = this.candidates[i];
            if (preTag == null || candidate.userInput) {
                toJoin[i] = candidate.term;
            } else {
                int maxLen = preTag.length + postTag.length + candidate.term.length;
                BytesRefBuilder highlighted = new BytesRefBuilder();
                highlighted.grow(maxLen);
                if (i == 0 || this.candidates[i - 1].userInput) {
                    highlighted.append(preTag);
                }
                highlighted.append(candidate.term);
                if (toJoin.length == i + 1 || this.candidates[i + 1].userInput) {
                    highlighted.append(postTag);
                }
                toJoin[i] = highlighted.get();
            }
            len += toJoin[i].length;
        }
        result.grow(len);
        return WordScorer.join(separator, result, toJoin);
    }

    @Override
    public int compareTo(Correction other) {
        return this.compareTo(other.score, other.candidates);
    }

    int compareTo(double otherScore, DirectCandidateGenerator.Candidate[] otherCandidates) {
        if (this.score == otherScore) {
            int limit = Math.min(this.candidates.length, otherCandidates.length);
            for (int i = 0; i < limit; ++i) {
                int cmp = this.candidates[i].term.compareTo(otherCandidates[i].term);
                if (cmp == 0) continue;
                return -cmp;
            }
            return this.candidates.length - otherCandidates.length;
        }
        return Double.compare(this.score, otherScore);
    }
}

