/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.search.suggest.phrase;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.MultiFields;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.apache.lucene.util.BytesRefBuilder;
import conductor.org.elasticsearch.common.lucene.index.FreqTermsEnum;
import conductor.org.elasticsearch.common.util.BigArrays;
import conductor.org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import java.io.IOException;

public abstract class WordScorer {
    protected final IndexReader reader;
    protected final String field;
    protected final Terms terms;
    protected final long vocabluarySize;
    protected final double realWordLikelihood;
    protected final BytesRefBuilder spare = new BytesRefBuilder();
    protected final BytesRef separator;
    private final TermsEnum termsEnum;
    private final long numTerms;
    private final boolean useTotalTermFreq;

    public WordScorer(IndexReader reader, String field, double realWordLikelihood, BytesRef separator) throws IOException {
        this(reader, MultiFields.getTerms(reader, field), field, realWordLikelihood, separator);
    }

    public WordScorer(IndexReader reader, Terms terms, String field, double realWordLikelihood, BytesRef separator) throws IOException {
        this.field = field;
        if (terms == null) {
            throw new IllegalArgumentException("Field: [" + field + "] does not exist");
        }
        this.terms = terms;
        long vocSize = terms.getSumTotalTermFreq();
        this.vocabluarySize = vocSize == -1L ? (long)reader.maxDoc() : vocSize;
        this.useTotalTermFreq = vocSize != -1L;
        long numTerms = terms.size();
        this.numTerms = this.vocabluarySize + numTerms > 1L ? numTerms : 0L;
        this.termsEnum = new FreqTermsEnum(reader, field, !this.useTotalTermFreq, this.useTotalTermFreq, null, BigArrays.NON_RECYCLING_INSTANCE);
        this.reader = reader;
        this.realWordLikelihood = realWordLikelihood;
        this.separator = separator;
    }

    public long frequency(BytesRef term) throws IOException {
        if (this.termsEnum.seekExact(term)) {
            return this.useTotalTermFreq ? this.termsEnum.totalTermFreq() : (long)this.termsEnum.docFreq();
        }
        return 0L;
    }

    protected double channelScore(DirectCandidateGenerator.Candidate candidate, DirectCandidateGenerator.Candidate original) throws IOException {
        if (candidate.stringDistance == 1.0) {
            return this.realWordLikelihood;
        }
        return candidate.stringDistance;
    }

    public double score(DirectCandidateGenerator.Candidate[] path, DirectCandidateGenerator.CandidateSet[] candidateSet, int at, int gramSize) throws IOException {
        if (at == 0 || gramSize == 1) {
            return Math.log10(this.channelScore(path[at], candidateSet[at].originalTerm) * this.scoreUnigram(path[at]));
        }
        if (at == 1 || gramSize == 2) {
            return Math.log10(this.channelScore(path[at], candidateSet[at].originalTerm) * this.scoreBigram(path[at], path[at - 1]));
        }
        return Math.log10(this.channelScore(path[at], candidateSet[at].originalTerm) * this.scoreTrigram(path[at], path[at - 1], path[at - 2]));
    }

    protected double scoreUnigram(DirectCandidateGenerator.Candidate word) throws IOException {
        return (1.0 + (double)this.frequency(word.term)) / (double)(this.vocabluarySize + this.numTerms);
    }

    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        return this.scoreUnigram(word);
    }

    protected double scoreTrigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        return this.scoreBigram(word, w_1);
    }

    public static BytesRef join(BytesRef separator, BytesRefBuilder result, BytesRef ... toJoin) {
        result.clear();
        for (int i = 0; i < toJoin.length - 1; ++i) {
            result.append(toJoin[i]);
            result.append(separator);
        }
        result.append(toJoin[toJoin.length - 1]);
        return result.get();
    }

    public static interface WordScorerFactory {
        public WordScorer newScorer(IndexReader var1, Terms var2, String var3, double var4, BytesRef var6) throws IOException;
    }
}

