/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.tasks;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.tasks.TaskListener;

public final class LoggingTaskListener<Response>
implements TaskListener<Response> {
    private static final Logger logger = LogManager.getLogger(LoggingTaskListener.class);
    private static final LoggingTaskListener<Object> INSTANCE = new LoggingTaskListener();

    public static <Response> TaskListener<Response> instance() {
        return INSTANCE;
    }

    private LoggingTaskListener() {
    }

    @Override
    public void onResponse(Task task, Response response) {
        logger.info("{} finished with response {}", (Object)task.getId(), (Object)response);
    }

    @Override
    public void onFailure(Task task, Throwable e) {
        logger.warn(() -> new ParameterizedMessage("{} failed with exception", (Object)task.getId()), e);
    }
}

