/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.Version;
import conductor.org.elasticsearch.tasks.Task;
import conductor.org.elasticsearch.tasks.TaskManager;
import conductor.org.elasticsearch.transport.TransportChannel;
import conductor.org.elasticsearch.transport.TransportResponse;
import java.io.IOException;

public class TaskTransportChannel
implements TransportChannel {
    private final Task task;
    private final TaskManager taskManager;
    private final TransportChannel channel;

    TaskTransportChannel(TaskManager taskManager, Task task, TransportChannel channel) {
        this.channel = channel;
        this.task = task;
        this.taskManager = taskManager;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfileName();
    }

    @Override
    public String getChannelType() {
        return this.channel.getChannelType();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.endTask();
        this.channel.sendResponse(response);
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        this.endTask();
        this.channel.sendResponse(exception);
    }

    @Override
    public Version getVersion() {
        return this.channel.getVersion();
    }

    public TransportChannel getChannel() {
        return this.channel;
    }

    private void endTask() {
        this.taskManager.unregister(this.task);
    }
}

