/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport;

import conductor.org.elasticsearch.common.unit.TimeValue;

public class TransportRequestOptions {
    private final TimeValue timeout;
    private final Type type;
    public static final TransportRequestOptions EMPTY = new Builder().build();

    private TransportRequestOptions(TimeValue timeout, Type type) {
        this.timeout = timeout;
        this.type = type;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public Type type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TransportRequestOptions options) {
        return new Builder().withTimeout(options.timeout).withType(options.type());
    }

    public static class Builder {
        private TimeValue timeout;
        private Type type = Type.REG;

        private Builder() {
        }

        public Builder withTimeout(long timeout) {
            return this.withTimeout(TimeValue.timeValueMillis(timeout));
        }

        public Builder withTimeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public TransportRequestOptions build() {
            return new TransportRequestOptions(this.timeout, this.type);
        }
    }

    public static enum Type {
        RECOVERY,
        BULK,
        REG,
        STATE,
        PING;

    }
}

