/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.transport.client;

import conductor.io.netty.util.ThreadDeathWatcher;
import conductor.io.netty.util.concurrent.GlobalEventExecutor;
import conductor.org.elasticsearch.client.transport.TransportClient;
import conductor.org.elasticsearch.common.SuppressForbidden;
import conductor.org.elasticsearch.common.network.NetworkModule;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.reindex.ReindexPlugin;
import conductor.org.elasticsearch.join.ParentJoinPlugin;
import conductor.org.elasticsearch.percolator.PercolatorPlugin;
import conductor.org.elasticsearch.plugins.Plugin;
import conductor.org.elasticsearch.script.mustache.MustachePlugin;
import conductor.org.elasticsearch.transport.Netty4Plugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class PreBuiltTransportClient
extends TransportClient {
    private static final Collection<Class<? extends Plugin>> PRE_INSTALLED_PLUGINS;

    private static void initializeNetty() {
        PreBuiltTransportClient.setSystemPropertyIfUnset("io.netty.noUnsafe", Boolean.toString(true));
        PreBuiltTransportClient.setSystemPropertyIfUnset("io.netty.noKeySetOptimization", Boolean.toString(true));
        PreBuiltTransportClient.setSystemPropertyIfUnset("io.netty.recycler.maxCapacityPerThread", Integer.toString(0));
    }

    @SuppressForbidden(reason="set system properties to configure Netty")
    private static void setSystemPropertyIfUnset(String key, String value) {
        String currentValue = System.getProperty(key);
        if (currentValue == null) {
            System.setProperty(key, value);
        }
    }

    @SafeVarargs
    public PreBuiltTransportClient(Settings settings, Class<? extends Plugin> ... plugins) {
        this(settings, Arrays.asList(plugins));
    }

    public PreBuiltTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        this(settings, plugins, null);
    }

    public PreBuiltTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins, TransportClient.HostFailureListener hostFailureListener) {
        super(settings, Settings.EMPTY, PreBuiltTransportClient.addPlugins(plugins, PRE_INSTALLED_PLUGINS), hostFailureListener);
    }

    @Override
    public void close() {
        super.close();
        if (!NetworkModule.TRANSPORT_TYPE_SETTING.exists(this.settings) || NetworkModule.TRANSPORT_TYPE_SETTING.get(this.settings).equals("netty4")) {
            try {
                GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                ThreadDeathWatcher.awaitInactivity(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        PreBuiltTransportClient.initializeNetty();
        PRE_INSTALLED_PLUGINS = Collections.unmodifiableList(Arrays.asList(Netty4Plugin.class, ReindexPlugin.class, PercolatorPlugin.class, MustachePlugin.class, ParentJoinPlugin.class));
    }
}

