/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.analysis.miscellaneous;

import conductor.org.apache.lucene.analysis.FilteringTokenFilter;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;

public class DateRecognizerFilter
extends FilteringTokenFilter {
    public static final String DATE_TYPE = "date";
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final DateFormat dateFormat;

    public DateRecognizerFilter(TokenStream input) {
        this(input, null);
    }

    public DateRecognizerFilter(TokenStream input, DateFormat dateFormat) {
        super(input);
        this.dateFormat = dateFormat != null ? dateFormat : DateFormat.getDateInstance(2, Locale.ENGLISH);
    }

    @Override
    public boolean accept() {
        try {
            this.dateFormat.parse(this.termAtt.toString());
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

