/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.document;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.FieldType;
import conductor.org.apache.lucene.document.SortedNumericDocValuesRangeQuery;
import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.DocValuesType;
import conductor.org.apache.lucene.index.FieldInfo;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.search.Query;
import java.io.IOException;

public class SortedNumericDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedNumericDocValuesField(String name, long value) {
        super(name, TYPE);
        this.fieldsData = value;
    }

    public static Query newSlowRangeQuery(String field, long lowerValue, long upperValue) {
        return new SortedNumericDocValuesRangeQuery(field, lowerValue, upperValue){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric(reader, field);
            }
        };
    }

    public static Query newSlowExactQuery(String field, long value) {
        return SortedNumericDocValuesField.newSlowRangeQuery(field, value, value);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

