/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.index;

import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.FieldInfos;
import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafMetaData;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.NumericDocValues;
import conductor.org.apache.lucene.index.PointValues;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.SortedDocValues;
import conductor.org.apache.lucene.index.SortedNumericDocValues;
import conductor.org.apache.lucene.index.SortedSetDocValues;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.Terms;
import conductor.org.apache.lucene.index.TermsEnum;
import conductor.org.apache.lucene.util.Bits;
import java.io.IOException;

public abstract class LeafReader
extends IndexReader {
    private final LeafReaderContext readerContext = new LeafReaderContext(this);

    protected LeafReader() {
    }

    @Override
    public final LeafReaderContext getContext() {
        this.ensureOpen();
        return this.readerContext;
    }

    public abstract IndexReader.CacheHelper getCoreCacheHelper();

    @Override
    public final int docFreq(Term term) throws IOException {
        Terms terms = this.terms(term.field());
        if (terms == null) {
            return 0;
        }
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.docFreq();
        }
        return 0;
    }

    @Override
    public final long totalTermFreq(Term term) throws IOException {
        Terms terms = this.terms(term.field());
        if (terms == null) {
            return 0L;
        }
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum.totalTermFreq();
        }
        return 0L;
    }

    @Override
    public final long getSumDocFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumDocFreq();
    }

    @Override
    public final int getDocCount(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0;
        }
        return terms.getDocCount();
    }

    @Override
    public final long getSumTotalTermFreq(String field) throws IOException {
        Terms terms = this.terms(field);
        if (terms == null) {
            return 0L;
        }
        return terms.getSumTotalTermFreq();
    }

    public abstract Terms terms(String var1) throws IOException;

    public final PostingsEnum postings(Term term, int flags) throws IOException {
        TermsEnum termsEnum;
        assert (term.field() != null);
        assert (term.bytes() != null);
        Terms terms = this.terms(term.field());
        if (terms != null && (termsEnum = terms.iterator()).seekExact(term.bytes())) {
            return termsEnum.postings(null, flags);
        }
        return null;
    }

    public final PostingsEnum postings(Term term) throws IOException {
        return this.postings(term, 8);
    }

    public abstract NumericDocValues getNumericDocValues(String var1) throws IOException;

    public abstract BinaryDocValues getBinaryDocValues(String var1) throws IOException;

    public abstract SortedDocValues getSortedDocValues(String var1) throws IOException;

    public abstract SortedNumericDocValues getSortedNumericDocValues(String var1) throws IOException;

    public abstract SortedSetDocValues getSortedSetDocValues(String var1) throws IOException;

    public abstract NumericDocValues getNormValues(String var1) throws IOException;

    public abstract FieldInfos getFieldInfos();

    public abstract Bits getLiveDocs();

    public abstract PointValues getPointValues(String var1) throws IOException;

    public abstract void checkIntegrity() throws IOException;

    public abstract LeafMetaData getMetaData();
}

