/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.queryparser.flexible.standard.processors;

import conductor.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import conductor.org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import conductor.org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import conductor.org.apache.lucene.queryparser.flexible.standard.nodes.AbstractRangeQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.standard.nodes.RegexpQueryNode;
import conductor.org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;
import conductor.org.apache.lucene.search.MultiTermQuery;
import java.util.List;

public class MultiTermRewriteMethodProcessor
extends QueryNodeProcessorImpl {
    public static final String TAG_ID = "MultiTermRewriteMethodConfiguration";

    @Override
    protected QueryNode postProcessNode(QueryNode node) {
        if (node instanceof WildcardQueryNode || node instanceof AbstractRangeQueryNode || node instanceof RegexpQueryNode) {
            MultiTermQuery.RewriteMethod rewriteMethod = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.MULTI_TERM_REWRITE_METHOD);
            if (rewriteMethod == null) {
                throw new IllegalArgumentException("StandardQueryConfigHandler.ConfigurationKeys.MULTI_TERM_REWRITE_METHOD should be set on the QueryConfigHandler");
            }
            node.setTag(TAG_ID, rewriteMethod);
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) {
        return children;
    }
}

