/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search;

import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.search.ConjunctionDISI;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.PhraseMatcher;
import conductor.org.apache.lucene.search.PhraseQuery;
import conductor.org.apache.lucene.search.similarities.Similarity;
import java.io.IOException;
import java.util.ArrayList;

final class ExactPhraseMatcher
extends PhraseMatcher {
    private final PostingsAndPosition[] postings;

    ExactPhraseMatcher(PhraseQuery.PostingsAndFreq[] postings, float matchCost) {
        super(ExactPhraseMatcher.approximation(postings), matchCost);
        ArrayList<PostingsAndPosition> postingsAndPositions = new ArrayList<PostingsAndPosition>();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            postingsAndPositions.add(new PostingsAndPosition(posting.postings, posting.position));
        }
        this.postings = postingsAndPositions.toArray(new PostingsAndPosition[postingsAndPositions.size()]);
    }

    private static DocIdSetIterator approximation(PhraseQuery.PostingsAndFreq[] postings) {
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            iterators.add(posting.postings);
        }
        return ConjunctionDISI.intersectIterators(iterators);
    }

    @Override
    float maxFreq() {
        int minFreq = this.postings[0].freq;
        for (int i = 1; i < this.postings.length; ++i) {
            minFreq = Math.min(minFreq, this.postings[i].freq);
        }
        return minFreq;
    }

    private static boolean advancePosition(PostingsAndPosition posting, int target) throws IOException {
        while (posting.pos < target) {
            if (posting.upTo == posting.freq) {
                return false;
            }
            posting.pos = posting.postings.nextPosition();
            PostingsAndPosition postingsAndPosition = posting;
            postingsAndPosition.upTo = postingsAndPosition.upTo + 1;
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        for (PostingsAndPosition posting : this.postings) {
            posting.freq = posting.postings.freq();
            posting.pos = -1;
            posting.upTo = 0;
        }
    }

    @Override
    public boolean nextMatch() throws IOException {
        block5: {
            PostingsAndPosition lead = this.postings[0];
            if (lead.upTo >= lead.freq) {
                return false;
            }
            lead.pos = lead.postings.nextPosition();
            lead.upTo = lead.upTo + 1;
            block0: while (true) {
                int phrasePos = lead.pos - lead.offset;
                for (int j = 1; j < this.postings.length; ++j) {
                    PostingsAndPosition posting = this.postings[j];
                    int expectedPos = phrasePos + posting.offset;
                    if (ExactPhraseMatcher.advancePosition(posting, expectedPos)) {
                        if (posting.pos == expectedPos) continue;
                        if (ExactPhraseMatcher.advancePosition(lead, posting.pos - posting.offset + lead.offset)) {
                            continue block0;
                        }
                    }
                    break block5;
                }
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    float sloppyWeight(Similarity.SimScorer simScorer) {
        return 1.0f;
    }

    @Override
    public int startPosition() {
        return this.postings[0].pos;
    }

    @Override
    public int endPosition() {
        return this.postings[this.postings.length - 1].pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.postings[0].postings.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.postings[this.postings.length - 1].postings.endOffset();
    }

    private static class PostingsAndPosition {
        private final PostingsEnum postings;
        private final int offset;
        private int freq;
        private int upTo;
        private int pos;

        public PostingsAndPosition(PostingsEnum postings, int offset) {
            this.postings = postings;
            this.offset = offset;
        }
    }
}

