/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.similarities;

import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.similarities.TFIDFSimilarity;
import conductor.org.apache.lucene.util.BytesRef;

public class ClassicSimilarity
extends TFIDFSimilarity {
    @Override
    public float lengthNorm(int numTerms) {
        return (float)(1.0 / Math.sqrt(numTerms));
    }

    @Override
    public float tf(float freq) {
        return (float)Math.sqrt(freq);
    }

    @Override
    public float sloppyFreq(int distance) {
        return 1.0f / (float)(distance + 1);
    }

    @Override
    public float scorePayload(int doc, int start, int end, BytesRef payload) {
        return 1.0f;
    }

    @Override
    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount() == -1L ? collectionStats.maxDoc() : collectionStats.docCount();
        float idf = this.idf(df, docCount);
        return Explanation.match(idf, "idf, computed as log((docCount+1)/(docFreq+1)) + 1 from:", Explanation.match((float)df, "docFreq", new Explanation[0]), Explanation.match((float)docCount, "docCount", new Explanation[0]));
    }

    @Override
    public float idf(long docFreq, long docCount) {
        return (float)(Math.log((double)(docCount + 1L) / (double)(docFreq + 1L)) + 1.0);
    }

    public String toString() {
        return "ClassicSimilarity";
    }
}

