/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.spans;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanWeight;
import java.io.IOException;
import java.util.Objects;

public final class FieldMaskingSpanQuery
extends SpanQuery {
    private final SpanQuery maskedQuery;
    private final String field;

    public FieldMaskingSpanQuery(SpanQuery maskedQuery, String maskedField) {
        this.maskedQuery = Objects.requireNonNull(maskedQuery);
        this.field = Objects.requireNonNull(maskedField);
    }

    @Override
    public String getField() {
        return this.field;
    }

    public SpanQuery getMaskedQuery() {
        return this.maskedQuery;
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return this.maskedQuery.createWeight(searcher, needsScores, boost);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewritten = (SpanQuery)this.maskedQuery.rewrite(reader);
        if (rewritten != this.maskedQuery) {
            return new FieldMaskingSpanQuery(rewritten, this.field);
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("mask(");
        buffer.append(this.maskedQuery.toString(field));
        buffer.append(")");
        buffer.append(" as ");
        buffer.append(this.field);
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((FieldMaskingSpanQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(FieldMaskingSpanQuery other) {
        return this.getField().equals(other.getField()) && this.getMaskedQuery().equals(other.getMaskedQuery());
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.getMaskedQuery().hashCode() ^ this.getField().hashCode();
    }
}

