/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.spans;

import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.PostingsEnum;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.index.TermContext;
import conductor.org.apache.lucene.search.CollectionStatistics;
import conductor.org.apache.lucene.search.Explanation;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Matches;
import conductor.org.apache.lucene.search.MatchesIterator;
import conductor.org.apache.lucene.search.MatchesUtils;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.TermQuery;
import conductor.org.apache.lucene.search.TermStatistics;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.similarities.Similarity;
import conductor.org.apache.lucene.search.spans.SpanCollector;
import conductor.org.apache.lucene.search.spans.SpanQuery;
import conductor.org.apache.lucene.search.spans.SpanScorer;
import conductor.org.apache.lucene.search.spans.Spans;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public abstract class SpanWeight
extends Weight {
    protected final Similarity similarity;
    protected final Similarity.SimWeight simWeight;
    protected final String field;

    public SpanWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermContext> termContexts, float boost) throws IOException {
        super(query);
        this.field = query.getField();
        this.similarity = searcher.getSimilarity(termContexts != null);
        this.simWeight = this.buildSimWeight(query, searcher, termContexts, boost);
    }

    private Similarity.SimWeight buildSimWeight(SpanQuery query, IndexSearcher searcher, Map<Term, TermContext> termContexts, float boost) throws IOException {
        if (termContexts == null || termContexts.size() == 0 || query.getField() == null) {
            return null;
        }
        TermStatistics[] termStats = new TermStatistics[termContexts.size()];
        int i = 0;
        for (Term term : termContexts.keySet()) {
            termStats[i] = searcher.termStatistics(term, termContexts.get(term));
            ++i;
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(query.getField());
        return this.similarity.computeWeight(boost, collectionStats, termStats);
    }

    public abstract void extractTermContexts(Map<Term, TermContext> var1);

    public abstract Spans getSpans(LeafReaderContext var1, Postings var2) throws IOException;

    @Override
    public SpanScorer scorer(LeafReaderContext context) throws IOException {
        Spans spans = this.getSpans(context, Postings.POSITIONS);
        if (spans == null) {
            return null;
        }
        Similarity.SimScorer docScorer = this.getSimScorer(context);
        return new SpanScorer(this, spans, docScorer);
    }

    public Similarity.SimScorer getSimScorer(LeafReaderContext context) throws IOException {
        return this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int newDoc;
        SpanScorer scorer = this.scorer(context);
        if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
            float freq = scorer.sloppyFreq();
            Similarity.SimScorer docScorer = this.similarity.simScorer(this.simWeight, context);
            Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
            Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
            return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
        }
        return Explanation.noMatch("no matching term", new Explanation[0]);
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return MatchesUtils.forField(this.field, () -> {
            final Spans spans = this.getSpans(context, Postings.OFFSETS);
            if (spans == null || spans.advance(doc) != doc) {
                return null;
            }
            return new MatchesIterator(){
                int innerTermCount = 0;
                TermMatch[] innerTerms = new TermMatch[0];
                SpanCollector termCollector = new SpanCollector(){

                    @Override
                    public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
                        ++innerTermCount;
                        if (innerTermCount > innerTerms.length) {
                            TermMatch[] temp = new TermMatch[innerTermCount];
                            System.arraycopy(innerTerms, 0, temp, 0, innerTermCount - 1);
                            innerTerms = temp;
                            innerTerms[innerTermCount - 1] = new TermMatch();
                        }
                        innerTerms[innerTermCount - 1].term = term;
                        innerTerms[innerTermCount - 1].position = position;
                        innerTerms[innerTermCount - 1].startOffset = postings.startOffset();
                        innerTerms[innerTermCount - 1].endOffset = postings.endOffset();
                    }

                    @Override
                    public void reset() {
                        innerTermCount = 0;
                    }
                };

                @Override
                public boolean next() throws IOException {
                    this.innerTermCount = 0;
                    return spans.nextStartPosition() != Integer.MAX_VALUE;
                }

                @Override
                public int startPosition() {
                    return spans.startPosition();
                }

                @Override
                public int endPosition() {
                    return spans.endPosition() - 1;
                }

                @Override
                public int startOffset() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return this.innerTerms[0].startOffset;
                }

                @Override
                public int endOffset() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return this.innerTerms[this.innerTermCount - 1].endOffset;
                }

                @Override
                public MatchesIterator getSubMatches() throws IOException {
                    if (this.innerTermCount == 0) {
                        this.collectInnerTerms();
                    }
                    return new MatchesIterator(){
                        int upto = -1;

                        @Override
                        public boolean next() throws IOException {
                            ++this.upto;
                            return this.upto < innerTermCount;
                        }

                        @Override
                        public int startPosition() {
                            return innerTerms[this.upto].position;
                        }

                        @Override
                        public int endPosition() {
                            return innerTerms[this.upto].position;
                        }

                        @Override
                        public int startOffset() throws IOException {
                            return innerTerms[this.upto].startOffset;
                        }

                        @Override
                        public int endOffset() throws IOException {
                            return innerTerms[this.upto].endOffset;
                        }

                        @Override
                        public MatchesIterator getSubMatches() throws IOException {
                            return null;
                        }

                        @Override
                        public Query getQuery() {
                            return new TermQuery(innerTerms[this.upto].term);
                        }
                    };
                }

                @Override
                public Query getQuery() {
                    return SpanWeight.this.getQuery();
                }

                void collectInnerTerms() throws IOException {
                    this.termCollector.reset();
                    spans.collect(this.termCollector);
                    Arrays.sort(this.innerTerms, 0, this.innerTermCount, Comparator.comparing(a -> a.position));
                }
            };
        });
    }

    private static class TermMatch {
        Term term;
        int position;
        int startOffset;
        int endOffset;

        private TermMatch() {
        }
    }

    public static enum Postings {
        POSITIONS{

            @Override
            public int getRequiredPostings() {
                return 24;
            }
        }
        ,
        PAYLOADS{

            @Override
            public int getRequiredPostings() {
                return 88;
            }
        }
        ,
        OFFSETS{

            @Override
            public int getRequiredPostings() {
                return 120;
            }
        };


        public abstract int getRequiredPostings();

        public Postings atLeast(Postings postings) {
            if (postings.compareTo(this) > 0) {
                return postings;
            }
            return this;
        }
    }
}

