/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.document;

import conductor.org.apache.lucene.analysis.Analyzer;
import conductor.org.apache.lucene.index.Term;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.suggest.BitsProducer;
import conductor.org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import conductor.org.apache.lucene.search.suggest.document.CompletionQuery;
import conductor.org.apache.lucene.search.suggest.document.CompletionTokenStream;
import conductor.org.apache.lucene.search.suggest.document.CompletionWeight;
import java.io.IOException;

public class PrefixCompletionQuery
extends CompletionQuery {
    protected final CompletionAnalyzer analyzer;

    public PrefixCompletionQuery(Analyzer analyzer, Term term) {
        this(analyzer, term, null);
    }

    public PrefixCompletionQuery(Analyzer analyzer, Term term, BitsProducer filter) {
        super(term, filter);
        this.analyzer = !(analyzer instanceof CompletionAnalyzer) ? new CompletionAnalyzer(analyzer) : (CompletionAnalyzer)analyzer;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        try (CompletionTokenStream stream = (CompletionTokenStream)this.analyzer.tokenStream(this.getField(), this.getTerm().text());){
            CompletionWeight completionWeight = new CompletionWeight(this, stream.toAutomaton());
            return completionWeight;
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

