/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.search.suggest.document;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.search.BulkScorer;
import conductor.org.apache.lucene.search.CollectionTerminatedException;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.suggest.document.CompletionQuery;
import conductor.org.apache.lucene.search.suggest.document.TopSuggestDocs;
import conductor.org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import java.io.IOException;

public class SuggestIndexSearcher
extends IndexSearcher {
    public SuggestIndexSearcher(IndexReader reader) {
        super(reader);
    }

    public TopSuggestDocs suggest(CompletionQuery query, int n, boolean skipDuplicates) throws IOException {
        TopSuggestDocsCollector collector = new TopSuggestDocsCollector(n, skipDuplicates);
        this.suggest(query, collector);
        return collector.get();
    }

    public void suggest(CompletionQuery query, TopSuggestDocsCollector collector) throws IOException {
        query = (CompletionQuery)query.rewrite(this.getIndexReader());
        Weight weight = query.createWeight(this, collector.needsScores(), 1.0f);
        for (LeafReaderContext context : this.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            try {
                scorer.score(collector.getLeafCollector(context), context.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }
}

