/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.apache.lucene.store;

import conductor.org.apache.lucene.store.IndexInput;
import conductor.org.apache.lucene.store.RandomAccessInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;

@Deprecated
public final class ByteArrayIndexInput
extends IndexInput
implements RandomAccessInput {
    private byte[] bytes;
    private final int offset;
    private final int length;
    private int pos;

    public ByteArrayIndexInput(String description, byte[] bytes) {
        this(description, bytes, 0, bytes.length);
    }

    public ByteArrayIndexInput(String description, byte[] bytes, int offs, int length) {
        super(description);
        this.offset = offs;
        this.bytes = bytes;
        this.length = length;
        this.pos = offs;
    }

    @Override
    public long getFilePointer() {
        return this.pos - this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long pos) throws EOFException {
        int newPos = Math.toIntExact(pos + (long)this.offset);
        try {
            if (pos < 0L || pos > (long)this.length) {
                throw new EOFException();
            }
        }
        finally {
            this.pos = newPos;
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    @Override
    public int readInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    @Override
    public long readLong() {
        int i1 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int i2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public int readVInt() {
        byte b;
        if ((b = this.bytes[this.pos++]) >= 0) {
            return b;
        }
        int i = b & 0x7F;
        b = this.bytes[this.pos++];
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= (b & 0xF) << 28;
        if ((b & 0xF0) == 0) {
            return i;
        }
        throw new RuntimeException("Invalid vInt detected (too many bits)");
    }

    @Override
    public long readVLong() {
        byte b;
        if ((b = this.bytes[this.pos++]) >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = this.bytes[this.pos++];
        i |= ((long)b & 0x7FL) << 56;
        if (b >= 0) {
            return i;
        }
        throw new RuntimeException("Invalid vLong detected (negative values disallowed)");
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }

    @Override
    public void close() {
        this.bytes = null;
    }

    @Override
    public IndexInput clone() {
        ByteArrayIndexInput slice = this.slice("(cloned)" + this.toString(), 0L, this.length());
        try {
            slice.seek(this.getFilePointer());
        }
        catch (EOFException e) {
            throw new UncheckedIOException(e);
        }
        return slice;
    }

    @Override
    public ByteArrayIndexInput slice(String sliceDescription, long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > (long)this.length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "slice(offset=%s, length=%s) is out of bounds: %s", offset, length, this));
        }
        return new ByteArrayIndexInput(sliceDescription, this.bytes, Math.toIntExact((long)this.offset + offset), Math.toIntExact(length));
    }

    @Override
    public byte readByte(long pos) throws IOException {
        return this.bytes[Math.toIntExact((long)this.offset + pos)];
    }

    @Override
    public short readShort(long pos) throws IOException {
        int i = Math.toIntExact((long)this.offset + pos);
        return (short)((this.bytes[i] & 0xFF) << 8 | this.bytes[i + 1] & 0xFF);
    }

    @Override
    public int readInt(long pos) throws IOException {
        int i = Math.toIntExact((long)this.offset + pos);
        return (this.bytes[i] & 0xFF) << 24 | (this.bytes[i + 1] & 0xFF) << 16 | (this.bytes[i + 2] & 0xFF) << 8 | this.bytes[i + 3] & 0xFF;
    }

    @Override
    public long readLong(long pos) throws IOException {
        return (long)this.readInt(pos) << 32 | (long)this.readInt(pos + 4L) & 0xFFFFFFFFL;
    }
}

