/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.common.CheckedConsumer;
import conductor.org.elasticsearch.common.util.concurrent.EsExecutors;
import conductor.org.elasticsearch.common.util.concurrent.FutureUtils;
import conductor.org.elasticsearch.common.util.concurrent.ListenableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class StepListener<Response>
implements ActionListener<Response> {
    private final ListenableFuture<Response> delegate = new ListenableFuture();

    @Override
    public void onResponse(Response response) {
        this.delegate.onResponse(response);
    }

    @Override
    public void onFailure(Exception e) {
        this.delegate.onFailure(e);
    }

    public void whenComplete(CheckedConsumer<Response, Exception> onResponse, Consumer<Exception> onFailure) {
        this.delegate.addListener(ActionListener.wrap(onResponse, onFailure), EsExecutors.newDirectExecutorService(), null);
    }

    public Response result() {
        if (!this.delegate.isDone()) {
            throw new IllegalStateException("step is not completed yet");
        }
        return FutureUtils.get(this.delegate, 0L, TimeUnit.NANOSECONDS);
    }
}

