/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public class TimestampParsingException
extends ElasticsearchException {
    private final String timestamp;

    public TimestampParsingException(String timestamp) {
        super("failed to parse timestamp [" + timestamp + "]", new Object[0]);
        this.timestamp = timestamp;
    }

    public TimestampParsingException(String timestamp, Throwable cause) {
        super("failed to parse timestamp [" + timestamp + "]", cause, new Object[0]);
        this.timestamp = timestamp;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public TimestampParsingException(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.timestamp);
    }
}

