/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.admin.cluster.node.liveness;

import conductor.org.elasticsearch.action.ActionResponse;
import conductor.org.elasticsearch.cluster.ClusterName;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import java.io.IOException;

public final class LivenessResponse
extends ActionResponse {
    private DiscoveryNode node;
    private ClusterName clusterName;

    public LivenessResponse() {
    }

    public LivenessResponse(ClusterName clusterName, DiscoveryNode node) {
        this.node = node;
        this.clusterName = clusterName;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = new ClusterName(in);
        this.node = in.readOptionalWriteable(DiscoveryNode::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        out.writeOptionalWriteable(this.node);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public DiscoveryNode getDiscoveryNode() {
        return this.node;
    }
}

