/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.fieldcaps;

import conductor.org.elasticsearch.action.fieldcaps.FieldCapabilities;
import conductor.org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import conductor.org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import conductor.org.elasticsearch.action.support.ActionFilters;
import conductor.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.block.ClusterBlockException;
import conductor.org.elasticsearch.cluster.block.ClusterBlockLevel;
import conductor.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import conductor.org.elasticsearch.cluster.routing.ShardsIterator;
import conductor.org.elasticsearch.cluster.service.ClusterService;
import conductor.org.elasticsearch.common.inject.Inject;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.index.mapper.ObjectMapper;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.indices.IndicesService;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;

public class TransportFieldCapabilitiesIndexAction
extends TransportSingleShardAction<FieldCapabilitiesIndexRequest, FieldCapabilitiesIndexResponse> {
    private static final String ACTION_NAME = "indices:data/read/field_caps[index]";
    private final IndicesService indicesService;

    @Inject
    public TransportFieldCapabilitiesIndexAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, FieldCapabilitiesIndexRequest::new, "management");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(FieldCapabilitiesIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected FieldCapabilitiesIndexResponse shardOperation(FieldCapabilitiesIndexRequest request, ShardId shardId) {
        MapperService mapperService = this.indicesService.indexServiceSafe(shardId.getIndex()).mapperService();
        HashSet<String> fieldNames = new HashSet<String>();
        for (String field : request.fields()) {
            fieldNames.addAll(mapperService.simpleMatchToFullName(field));
        }
        Predicate<String> fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
        HashMap<String, FieldCapabilities> responseMap = new HashMap<String, FieldCapabilities>();
        for (String field : fieldNames) {
            String parentField;
            MappedFieldType ft = mapperService.fullName(field);
            if (ft == null || !this.indicesService.isMetaDataField(field) && !fieldPredicate.test(ft.name())) continue;
            FieldCapabilities fieldCap = new FieldCapabilities(field, ft.typeName(), ft.isSearchable(), ft.isAggregatable());
            responseMap.put(field, fieldCap);
            int dotIndex = ft.name().lastIndexOf(46);
            while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                if (mapperService.fullName(parentField) == null) {
                    ObjectMapper mapper = mapperService.getObjectMapper(parentField);
                    String type = mapper.nested().isNested() ? "nested" : "object";
                    FieldCapabilities fieldCap2 = new FieldCapabilities(parentField, type, false, false);
                    responseMap.put(parentField, fieldCap2);
                }
                dotIndex = parentField.lastIndexOf(46);
            }
        }
        return new FieldCapabilitiesIndexResponse(shardId.getIndexName(), responseMap);
    }

    @Override
    protected FieldCapabilitiesIndexResponse newResponse() {
        return new FieldCapabilitiesIndexResponse();
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }
}

