/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.index;

import conductor.org.elasticsearch.action.DocWriteResponse;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.rest.RestStatus;
import java.io.IOException;

public class IndexResponse
extends DocWriteResponse {
    public IndexResponse() {
    }

    public IndexResponse(ShardId shardId, String type, String id, long seqNo, long primaryTerm, long version, boolean created) {
        this(shardId, type, id, seqNo, primaryTerm, version, created ? DocWriteResponse.Result.CREATED : DocWriteResponse.Result.UPDATED);
    }

    private IndexResponse(ShardId shardId, String type, String id, long seqNo, long primaryTerm, long version, DocWriteResponse.Result result) {
        super(shardId, type, id, seqNo, primaryTerm, version, IndexResponse.assertCreatedOrUpdated(result));
    }

    private static DocWriteResponse.Result assertCreatedOrUpdated(DocWriteResponse.Result result) {
        assert (result == DocWriteResponse.Result.CREATED || result == DocWriteResponse.Result.UPDATED);
        return result;
    }

    @Override
    public RestStatus status() {
        return this.result == DocWriteResponse.Result.CREATED ? RestStatus.CREATED : super.status();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IndexResponse[");
        builder.append("index=").append(this.getIndex());
        builder.append(",type=").append(this.getType());
        builder.append(",id=").append(this.getId());
        builder.append(",version=").append(this.getVersion());
        builder.append(",result=").append(this.getResult().getLowercase());
        builder.append(",seqNo=").append(this.getSeqNo());
        builder.append(",primaryTerm=").append(this.getPrimaryTerm());
        builder.append(",shards=").append(Strings.toString(this.getShardInfo()));
        return builder.append("]").toString();
    }

    public static IndexResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        Builder context = new Builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            IndexResponse.parseXContentFields(parser, context);
        }
        return context.build();
    }

    public static void parseXContentFields(XContentParser parser, Builder context) throws IOException {
        DocWriteResponse.parseInnerToXContent(parser, context);
    }

    public static class Builder
    extends DocWriteResponse.Builder {
        @Override
        public IndexResponse build() {
            IndexResponse indexResponse = new IndexResponse(this.shardId, this.type, this.id, this.seqNo, this.primaryTerm, this.version, this.result);
            indexResponse.setForcedRefresh(this.forcedRefresh);
            if (this.shardInfo != null) {
                indexResponse.setShardInfo(this.shardInfo);
            }
            return indexResponse;
        }
    }
}

