/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.action.search;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.action.OriginalIndices;
import conductor.org.elasticsearch.action.ShardOperationFailedException;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentParserUtils;
import conductor.org.elasticsearch.index.Index;
import conductor.org.elasticsearch.index.shard.ShardId;
import conductor.org.elasticsearch.rest.RestStatus;
import conductor.org.elasticsearch.search.SearchException;
import conductor.org.elasticsearch.search.SearchShardTarget;
import java.io.IOException;

public class ShardSearchFailure
extends ShardOperationFailedException {
    private static final String REASON_FIELD = "reason";
    private static final String NODE_FIELD = "node";
    private static final String INDEX_FIELD = "index";
    private static final String SHARD_FIELD = "shard";
    public static final ShardSearchFailure[] EMPTY_ARRAY = new ShardSearchFailure[0];
    private SearchShardTarget shardTarget;

    ShardSearchFailure() {
    }

    public ShardSearchFailure(Exception e) {
        this(e, null);
    }

    public ShardSearchFailure(Exception e, @Nullable SearchShardTarget shardTarget) {
        super(shardTarget == null ? null : shardTarget.getFullyQualifiedIndexName(), shardTarget == null ? -1 : shardTarget.getShardId().getId(), ExceptionsHelper.detailedMessage(e), ExceptionsHelper.status(ExceptionsHelper.unwrapCause(e)), ExceptionsHelper.unwrapCause(e));
        Throwable actual = ExceptionsHelper.unwrapCause(e);
        if (actual instanceof SearchException) {
            this.shardTarget = ((SearchException)actual).shard();
        } else if (shardTarget != null) {
            this.shardTarget = shardTarget;
        }
    }

    @Nullable
    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    public String toString() {
        return "shard [" + (this.shardTarget == null ? "_na" : this.shardTarget) + "], reason [" + this.reason + "], cause [" + (this.cause == null ? "_na" : ExceptionsHelper.stackTrace(this.cause)) + "]";
    }

    public static ShardSearchFailure readShardSearchFailure(StreamInput in) throws IOException {
        ShardSearchFailure shardSearchFailure = new ShardSearchFailure();
        shardSearchFailure.readFrom(in);
        return shardSearchFailure;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardTarget = in.readOptionalWriteable(SearchShardTarget::new);
        if (this.shardTarget != null) {
            this.index = this.shardTarget.getFullyQualifiedIndexName();
            this.shardId = this.shardTarget.getShardId().getId();
        }
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
        this.cause = in.readException();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.shardTarget);
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
        out.writeException(this.cause);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHARD_FIELD, this.shardId());
        builder.field(INDEX_FIELD, this.index());
        if (this.shardTarget != null) {
            builder.field(NODE_FIELD, this.shardTarget.getNodeId());
        }
        builder.field(REASON_FIELD);
        builder.startObject();
        ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
        builder.endObject();
        return builder;
    }

    public static ShardSearchFailure fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        String currentFieldName = null;
        int shardId = -1;
        String indexName = null;
        String clusterAlias = null;
        String nodeId = null;
        ElasticsearchException exception = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SHARD_FIELD.equals(currentFieldName)) {
                    shardId = parser.intValue();
                    continue;
                }
                if (INDEX_FIELD.equals(currentFieldName)) {
                    indexName = parser.text();
                    int indexOf = indexName.indexOf(58);
                    if (indexOf <= 0) continue;
                    clusterAlias = indexName.substring(0, indexOf);
                    indexName = indexName.substring(indexOf + 1);
                    continue;
                }
                if (NODE_FIELD.equals(currentFieldName)) {
                    nodeId = parser.text();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (REASON_FIELD.equals(currentFieldName)) {
                    exception = ElasticsearchException.fromXContent(parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        SearchShardTarget searchShardTarget = null;
        if (nodeId != null) {
            searchShardTarget = new SearchShardTarget(nodeId, new ShardId(new Index(indexName, "_na_"), shardId), clusterAlias, OriginalIndices.NONE);
        }
        return new ShardSearchFailure(exception, searchShardTarget);
    }
}

