/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.search.SearchRequest;
import conductor.org.elasticsearch.action.search.SearchResponse;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.RollupRequestConverters;
import conductor.org.elasticsearch.client.core.AcknowledgedResponse;
import conductor.org.elasticsearch.client.rollup.DeleteRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.GetRollupCapsRequest;
import conductor.org.elasticsearch.client.rollup.GetRollupCapsResponse;
import conductor.org.elasticsearch.client.rollup.GetRollupIndexCapsRequest;
import conductor.org.elasticsearch.client.rollup.GetRollupIndexCapsResponse;
import conductor.org.elasticsearch.client.rollup.GetRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.GetRollupJobResponse;
import conductor.org.elasticsearch.client.rollup.PutRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.StartRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.StartRollupJobResponse;
import conductor.org.elasticsearch.client.rollup.StopRollupJobRequest;
import conductor.org.elasticsearch.client.rollup.StopRollupJobResponse;
import java.io.IOException;
import java.util.Collections;

public class RollupClient {
    private final RestHighLevelClient restHighLevelClient;

    RollupClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putRollupJob(PutRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::putJob, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putRollupJobAsync(PutRollupJobRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::putJob, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartRollupJobResponse startRollupJob(StartRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::startJob, options, StartRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void startRollupJobAsync(StartRollupJobRequest request, RequestOptions options, ActionListener<StartRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::startJob, options, StartRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public StopRollupJobResponse stopRollupJob(StopRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::stopJob, options, StopRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void stopRollupJobAsync(StopRollupJobRequest request, RequestOptions options, ActionListener<StopRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::stopJob, options, StopRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteRollupJob(DeleteRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::deleteJob, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteRollupJobAsync(DeleteRollupJobRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::deleteJob, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupJobResponse getRollupJob(GetRollupJobRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupJobAsync(GetRollupJobRequest request, RequestOptions options, ActionListener<GetRollupJobResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getJob, options, GetRollupJobResponse::fromXContent, listener, Collections.emptySet());
    }

    public SearchResponse search(SearchRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::search, options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public void searchAsync(SearchRequest request, RequestOptions options, ActionListener<SearchResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::search, options, SearchResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupCapsResponse getRollupCapabilities(GetRollupCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupCapabilitiesAsync(GetRollupCapsRequest request, RequestOptions options, ActionListener<GetRollupCapsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupCaps, options, GetRollupCapsResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRollupIndexCapsResponse getRollupIndexCapabilities(GetRollupIndexCapsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, RollupRequestConverters::getRollupIndexCaps, options, GetRollupIndexCapsResponse::fromXContent, Collections.emptySet());
    }

    public void getRollupIndexCapabilitiesAsync(GetRollupIndexCapsRequest request, RequestOptions options, ActionListener<GetRollupIndexCapsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RollupRequestConverters::getRollupIndexCaps, options, GetRollupIndexCapsResponse::fromXContent, listener, Collections.emptySet());
    }
}

