/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client;

import conductor.org.elasticsearch.action.ActionListener;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import conductor.org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import conductor.org.elasticsearch.client.RequestOptions;
import conductor.org.elasticsearch.client.RestHighLevelClient;
import conductor.org.elasticsearch.client.TasksRequestConverters;
import conductor.org.elasticsearch.client.tasks.GetTaskRequest;
import conductor.org.elasticsearch.client.tasks.GetTaskResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;

public final class TasksClient {
    private final RestHighLevelClient restHighLevelClient;

    TasksClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public ListTasksResponse list(ListTasksRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, TasksRequestConverters::listTasks, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public void listAsync(ListTasksRequest request, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, TasksRequestConverters::listTasks, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public Optional<GetTaskResponse> get(GetTaskRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseOptionalEntity(request, TasksRequestConverters::getTask, options, GetTaskResponse::fromXContent);
    }

    public void getAsync(GetTaskRequest request, RequestOptions options, ActionListener<Optional<GetTaskResponse>> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseOptionalEntity(request, TasksRequestConverters::getTask, options, GetTaskResponse::fromXContent, listener);
    }

    public CancelTasksResponse cancel(CancelTasksRequest cancelTasksRequest, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(cancelTasksRequest, TasksRequestConverters::cancelTasks, options, CancelTasksResponse::fromXContent, Collections.emptySet());
    }

    public void cancelAsync(CancelTasksRequest cancelTasksRequest, RequestOptions options, ActionListener<CancelTasksResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(cancelTasksRequest, TasksRequestConverters::cancelTasks, options, CancelTasksResponse::fromXContent, listener, Collections.emptySet());
    }
}

