/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.indexlifecycle;

import conductor.org.elasticsearch.client.indexlifecycle.IndexLifecycleExplainResponse;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.Strings;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExplainLifecycleResponse
implements ToXContentObject {
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private Map<String, IndexLifecycleExplainResponse> indexResponses;
    private static final ConstructingObjectParser<ExplainLifecycleResponse, Void> PARSER = new ConstructingObjectParser("explain_lifecycle_response", a -> new ExplainLifecycleResponse(((List)a[0]).stream().collect(Collectors.toMap(IndexLifecycleExplainResponse::getIndex, Function.identity()))));

    public static ExplainLifecycleResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public ExplainLifecycleResponse(Map<String, IndexLifecycleExplainResponse> indexResponses) {
        this.indexResponses = indexResponses;
    }

    public Map<String, IndexLifecycleExplainResponse> getIndexResponses() {
        return this.indexResponses;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(INDICES_FIELD.getPreferredName());
        for (IndexLifecycleExplainResponse indexResponse : this.indexResponses.values()) {
            builder.field(indexResponse.getIndex(), indexResponse);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indexResponses);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExplainLifecycleResponse other = (ExplainLifecycleResponse)obj;
        return Objects.equals(this.indexResponses, other.indexResponses);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> IndexLifecycleExplainResponse.PARSER.apply(p, (Void)c), INDICES_FIELD);
    }
}

