/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml.filestructurefinder;

import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FieldStats
implements ToXContentObject {
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    public static final ParseField CARDINALITY = new ParseField("cardinality", new String[0]);
    public static final ParseField MIN_VALUE = new ParseField("min_value", new String[0]);
    public static final ParseField MAX_VALUE = new ParseField("max_value", new String[0]);
    public static final ParseField MEAN_VALUE = new ParseField("mean_value", new String[0]);
    public static final ParseField MEDIAN_VALUE = new ParseField("median_value", new String[0]);
    public static final ParseField TOP_HITS = new ParseField("top_hits", new String[0]);
    public static final ConstructingObjectParser<FieldStats, Void> PARSER = new ConstructingObjectParser("field_stats", true, a -> new FieldStats((Long)a[0], (Integer)a[1], (Double)a[2], (Double)a[3], (Double)a[4], (Double)a[5], (List)a[6]));
    private final long count;
    private final int cardinality;
    private final Double minValue;
    private final Double maxValue;
    private final Double meanValue;
    private final Double medianValue;
    private final List<Map<String, Object>> topHits;

    FieldStats(long count, int cardinality, Double minValue, Double maxValue, Double meanValue, Double medianValue, List<Map<String, Object>> topHits) {
        this.count = count;
        this.cardinality = cardinality;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.meanValue = meanValue;
        this.medianValue = medianValue;
        this.topHits = topHits == null ? Collections.emptyList() : Collections.unmodifiableList(topHits);
    }

    public long getCount() {
        return this.count;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Double getMeanValue() {
        return this.meanValue;
    }

    public Double getMedianValue() {
        return this.medianValue;
    }

    public List<Map<String, Object>> getTopHits() {
        return this.topHits;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(COUNT.getPreferredName(), this.count);
        builder.field(CARDINALITY.getPreferredName(), this.cardinality);
        if (this.minValue != null) {
            builder.field(MIN_VALUE.getPreferredName(), FieldStats.toIntegerIfInteger(this.minValue));
        }
        if (this.maxValue != null) {
            builder.field(MAX_VALUE.getPreferredName(), FieldStats.toIntegerIfInteger(this.maxValue));
        }
        if (this.meanValue != null) {
            builder.field(MEAN_VALUE.getPreferredName(), FieldStats.toIntegerIfInteger(this.meanValue));
        }
        if (this.medianValue != null) {
            builder.field(MEDIAN_VALUE.getPreferredName(), FieldStats.toIntegerIfInteger(this.medianValue));
        }
        if (!this.topHits.isEmpty()) {
            builder.field(TOP_HITS.getPreferredName(), this.topHits);
        }
        builder.endObject();
        return builder;
    }

    static Number toIntegerIfInteger(double d) {
        if (d >= -2.147483648E9 && d <= 2.147483647E9 && Double.compare(d, StrictMath.rint(d)) == 0) {
            return (int)d;
        }
        return d;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.cardinality, this.minValue, this.maxValue, this.meanValue, this.medianValue, this.topHits);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldStats that = (FieldStats)other;
        return this.count == that.count && this.cardinality == that.cardinality && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.meanValue, that.meanValue) && Objects.equals(this.medianValue, that.medianValue) && Objects.equals(this.topHits, that.topHits);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), COUNT);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), CARDINALITY);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MIN_VALUE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MAX_VALUE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MEAN_VALUE);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MEDIAN_VALUE);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), TOP_HITS);
    }
}

