/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.client.ml.job.config;

import conductor.org.elasticsearch.client.ml.job.config.RuleAction;
import conductor.org.elasticsearch.client.ml.job.config.RuleCondition;
import conductor.org.elasticsearch.client.ml.job.config.RuleScope;
import conductor.org.elasticsearch.common.ParseField;
import conductor.org.elasticsearch.common.xcontent.ObjectParser;
import conductor.org.elasticsearch.common.xcontent.ToXContent;
import conductor.org.elasticsearch.common.xcontent.ToXContentObject;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public class DetectionRule
implements ToXContentObject {
    public static final ParseField DETECTION_RULE_FIELD = new ParseField("detection_rule", new String[0]);
    public static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[0]);
    public static final ParseField SCOPE_FIELD = new ParseField("scope", new String[0]);
    public static final ParseField CONDITIONS_FIELD = new ParseField("conditions", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser(DETECTION_RULE_FIELD.getPreferredName(), true, Builder::new);
    private final EnumSet<RuleAction> actions;
    private final RuleScope scope;
    private final List<RuleCondition> conditions;

    private DetectionRule(EnumSet<RuleAction> actions, RuleScope scope, List<RuleCondition> conditions) {
        this.actions = Objects.requireNonNull(actions);
        this.scope = Objects.requireNonNull(scope);
        this.conditions = Collections.unmodifiableList(conditions);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTIONS_FIELD.getPreferredName(), this.actions);
        if (!this.scope.isEmpty()) {
            builder.field(SCOPE_FIELD.getPreferredName(), this.scope);
        }
        if (!this.conditions.isEmpty()) {
            builder.field(CONDITIONS_FIELD.getPreferredName(), this.conditions);
        }
        builder.endObject();
        return builder;
    }

    public EnumSet<RuleAction> getActions() {
        return this.actions;
    }

    public RuleScope getScope() {
        return this.scope;
    }

    public List<RuleCondition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DetectionRule)) {
            return false;
        }
        DetectionRule other = (DetectionRule)obj;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.scope, other.scope) && Objects.equals(this.conditions, other.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.scope, this.conditions);
    }

    static {
        PARSER.declareStringArray(Builder::setActions, ACTIONS_FIELD);
        PARSER.declareObject(Builder::setScope, RuleScope.parser(), SCOPE_FIELD);
        PARSER.declareObjectArray(Builder::setConditions, RuleCondition.PARSER, CONDITIONS_FIELD);
    }

    public static class Builder {
        private EnumSet<RuleAction> actions = EnumSet.of(RuleAction.SKIP_RESULT);
        private RuleScope scope = new RuleScope();
        private List<RuleCondition> conditions = Collections.emptyList();

        public Builder(RuleScope.Builder scope) {
            this.scope = scope.build();
        }

        public Builder(List<RuleCondition> conditions) {
            this.conditions = Objects.requireNonNull(conditions);
        }

        Builder() {
        }

        public Builder setActions(List<String> actions) {
            this.actions.clear();
            actions.stream().map(RuleAction::fromString).forEach(this.actions::add);
            return this;
        }

        public Builder setActions(EnumSet<RuleAction> actions) {
            this.actions = Objects.requireNonNull(actions, ACTIONS_FIELD.getPreferredName());
            return this;
        }

        public Builder setActions(RuleAction ... actions) {
            this.actions.clear();
            Arrays.stream(actions).forEach(this.actions::add);
            return this;
        }

        public Builder setScope(RuleScope scope) {
            this.scope = Objects.requireNonNull(scope);
            return this;
        }

        public Builder setConditions(List<RuleCondition> conditions) {
            this.conditions = Objects.requireNonNull(conditions);
            return this;
        }

        public DetectionRule build() {
            return new DetectionRule(this.actions, this.scope, this.conditions);
        }
    }
}

