/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.cluster.block;

import conductor.org.elasticsearch.ElasticsearchException;
import conductor.org.elasticsearch.cluster.block.ClusterBlock;
import conductor.org.elasticsearch.common.io.stream.StreamInput;
import conductor.org.elasticsearch.common.io.stream.StreamOutput;
import conductor.org.elasticsearch.rest.RestStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClusterBlockException
extends ElasticsearchException {
    private final Set<ClusterBlock> blocks;

    public ClusterBlockException(Set<ClusterBlock> blocks) {
        super(ClusterBlockException.buildMessage(blocks), new Object[0]);
        this.blocks = blocks;
    }

    public ClusterBlockException(StreamInput in) throws IOException {
        super(in);
        int totalBlocks = in.readVInt();
        HashSet<ClusterBlock> blocks = new HashSet<ClusterBlock>(totalBlocks);
        for (int i = 0; i < totalBlocks; ++i) {
            blocks.add(ClusterBlock.readClusterBlock(in));
        }
        this.blocks = Collections.unmodifiableSet(blocks);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.blocks != null) {
            out.writeVInt(this.blocks.size());
            for (ClusterBlock block : this.blocks) {
                block.writeTo(out);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessage(Set<ClusterBlock> blocks) {
        StringBuilder sb = new StringBuilder("blocked by: ");
        for (ClusterBlock block : blocks) {
            sb.append("[").append((Object)block.status()).append("/").append(block.id()).append("/").append(block.description()).append("];");
        }
        return sb.toString();
    }

    @Override
    public RestStatus status() {
        RestStatus status = null;
        for (ClusterBlock block : this.blocks) {
            if (status == null) {
                status = block.status();
                continue;
            }
            if (status.getStatus() >= block.status().getStatus()) continue;
            status = block.status();
        }
        return status;
    }
}

