/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.blobstore;

import conductor.org.elasticsearch.common.blobstore.BlobMetaData;
import conductor.org.elasticsearch.common.blobstore.BlobPath;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Map;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1);

    public InputStream readBlob(String var1) throws IOException;

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    default public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public void deleteBlob(String var1) throws IOException;

    default public void deleteBlobIgnoringIfNotExists(String blobName) throws IOException {
        try {
            this.deleteBlob(blobName);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public Map<String, BlobMetaData> listBlobs() throws IOException;

    public Map<String, BlobMetaData> listBlobsByPrefix(String var1) throws IOException;
}

