/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.component;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.common.component.Lifecycle;
import conductor.org.elasticsearch.common.component.LifecycleComponent;
import conductor.org.elasticsearch.common.component.LifecycleListener;
import conductor.org.elasticsearch.common.settings.Settings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractLifecycleComponent
implements LifecycleComponent {
    private static final Logger logger = LogManager.getLogger(AbstractLifecycleComponent.class);
    protected final Lifecycle lifecycle = new Lifecycle();
    private final List<LifecycleListener> listeners = new CopyOnWriteArrayList<LifecycleListener>();

    protected AbstractLifecycleComponent() {
    }

    @Deprecated
    protected AbstractLifecycleComponent(Settings settings) {
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void start() {
        if (!this.lifecycle.canMoveToStarted()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStart();
        }
        this.doStart();
        this.lifecycle.moveToStarted();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStart();
        }
    }

    protected abstract void doStart();

    @Override
    public void stop() {
        if (!this.lifecycle.canMoveToStopped()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStop();
        }
        this.lifecycle.moveToStopped();
        this.doStop();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStop();
        }
    }

    protected abstract void doStop();

    @Override
    public void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.canMoveToClosed()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeClose();
        }
        this.lifecycle.moveToClosed();
        try {
            this.doClose();
        }
        catch (IOException e) {
            logger.warn("failed to close " + this.getClass().getName(), (Throwable)e);
        }
        for (LifecycleListener listener : this.listeners) {
            listener.afterClose();
        }
    }

    protected abstract void doClose() throws IOException;
}

