/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.joda;

import conductor.org.elasticsearch.common.time.DateFormatter;
import conductor.org.elasticsearch.common.time.FormatNames;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JodaDeprecationPatterns {
    public static final String USE_PREFIX_8_WARNING = "Prefix your date format with '8' to use the new specifier.";
    private static Map<String, String> JODA_PATTERNS_DEPRECATIONS = new LinkedHashMap<String, String>();

    public static boolean isDeprecatedPattern(String pattern) {
        List<String> patterns = DateFormatter.splitCombinedPatterns(pattern);
        for (String subPattern : patterns) {
            boolean isDeprecated = !subPattern.startsWith("8") && !FormatNames.exist(subPattern) && JODA_PATTERNS_DEPRECATIONS.keySet().stream().filter(s -> subPattern.contains((CharSequence)s)).findAny().isPresent();
            if (!isDeprecated) continue;
            return true;
        }
        return false;
    }

    public static String formatSuggestion(String pattern) {
        List<String> patterns = DateFormatter.splitCombinedPatterns(pattern);
        LinkedHashSet<String> warnings = new LinkedHashSet<String>();
        for (String subPattern : patterns) {
            if (!JodaDeprecationPatterns.isDeprecatedPattern(subPattern)) continue;
            String suggestion = JODA_PATTERNS_DEPRECATIONS.entrySet().stream().filter(s -> subPattern.contains((CharSequence)s.getKey())).map(s -> (String)s.getValue()).collect(Collectors.joining("; "));
            warnings.add(suggestion);
        }
        String combinedWarning = warnings.stream().collect(Collectors.joining("; "));
        return combinedWarning;
    }

    static {
        JODA_PATTERNS_DEPRECATIONS.put("Y", "'Y' year-of-era should be replaced with 'y'. Use 'Y' for week-based-year.");
        JODA_PATTERNS_DEPRECATIONS.put("y", "'y' year should be replaced with 'u'. Use 'y' for year-of-era.");
        JODA_PATTERNS_DEPRECATIONS.put("C", "'C' century of era is no longer supported.");
        JODA_PATTERNS_DEPRECATIONS.put("x", "'x' weak-year should be replaced with 'Y'. Use 'x' for zone-offset.");
        JODA_PATTERNS_DEPRECATIONS.put("Z", "'Z' time zone offset/id fails when parsing 'Z' for Zulu timezone. Consider using 'X'.");
        JODA_PATTERNS_DEPRECATIONS.put("z", "'z' time zone text. Will print 'Z' for Zulu given UTC timezone.");
    }
}

