/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.common.logging;

import conductor.org.apache.logging.log4j.core.LogEvent;
import conductor.org.apache.logging.log4j.core.config.plugins.Plugin;
import conductor.org.apache.logging.log4j.core.pattern.ConverterKeys;
import conductor.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import conductor.org.apache.lucene.util.SetOnce;
import java.util.Arrays;

@Plugin(category="Converter", name="NodeNamePatternConverter")
@ConverterKeys(value={"node_name"})
public final class NodeNamePatternConverter
extends LogEventPatternConverter {
    private static final SetOnce<String> NODE_NAME = new SetOnce();

    static void setNodeName(String nodeName) {
        NODE_NAME.set(nodeName);
    }

    public static NodeNamePatternConverter newInstance(String[] options) {
        if (options.length > 0) {
            throw new IllegalArgumentException("no options supported but options provided: " + Arrays.toString(options));
        }
        return new NodeNamePatternConverter();
    }

    private NodeNamePatternConverter() {
        super("NodeName", "node_name");
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        String nodeName = NODE_NAME.get();
        toAppendTo.append(nodeName == null ? "unknown" : nodeName);
    }
}

