/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.discovery;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.elasticsearch.cluster.ClusterState;
import conductor.org.elasticsearch.cluster.node.DiscoveryNode;
import conductor.org.elasticsearch.cluster.routing.allocation.AllocationService;
import conductor.org.elasticsearch.cluster.service.ClusterApplier;
import conductor.org.elasticsearch.cluster.service.MasterService;
import conductor.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import conductor.org.elasticsearch.common.network.NetworkService;
import conductor.org.elasticsearch.common.settings.ClusterSettings;
import conductor.org.elasticsearch.common.settings.Setting;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.common.transport.TransportAddress;
import conductor.org.elasticsearch.discovery.Discovery;
import conductor.org.elasticsearch.discovery.single.SingleNodeDiscovery;
import conductor.org.elasticsearch.discovery.zen.FileBasedUnicastHostsProvider;
import conductor.org.elasticsearch.discovery.zen.SettingsBasedHostsProvider;
import conductor.org.elasticsearch.discovery.zen.UnicastHostsProvider;
import conductor.org.elasticsearch.discovery.zen.ZenDiscovery;
import conductor.org.elasticsearch.plugins.DiscoveryPlugin;
import conductor.org.elasticsearch.threadpool.ThreadPool;
import conductor.org.elasticsearch.transport.TransportService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DiscoveryModule {
    private static final Logger logger = LogManager.getLogger(DiscoveryModule.class);
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> DISCOVERY_HOSTS_PROVIDER_SETTING = Setting.listSetting("discovery.zen.hosts_provider", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, List<DiscoveryPlugin> plugins, AllocationService allocationService, Path configFile) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> joinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        HashMap<String, Supplier<UnicastHostsProvider>> hostProviders = new HashMap<String, Supplier<UnicastHostsProvider>>();
        hostProviders.put("settings", () -> new SettingsBasedHostsProvider(settings, transportService));
        hostProviders.put("file", () -> new FileBasedUnicastHostsProvider(configFile));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getZenHostsProviders(transportService, networkService).entrySet().forEach(entry -> {
                if (hostProviders.put((String)entry.getKey(), (Supplier)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register zen hosts provider [" + (String)entry.getKey() + "] twice");
                }
            });
            BiConsumer<DiscoveryNode, ClusterState> joinValidator = plugin.getJoinValidator();
            if (joinValidator == null) continue;
            joinValidators.add(joinValidator);
        }
        List<String> hostsProviderNames = DISCOVERY_HOSTS_PROVIDER_SETTING.get(settings);
        if (!hostsProviderNames.contains("settings")) {
            ArrayList<String> extendedHostsProviderNames = new ArrayList<String>();
            extendedHostsProviderNames.add("settings");
            extendedHostsProviderNames.addAll(hostsProviderNames);
            hostsProviderNames = extendedHostsProviderNames;
        }
        HashSet<String> missingProviderNames = new HashSet<String>(hostsProviderNames);
        missingProviderNames.removeAll(hostProviders.keySet());
        if (!missingProviderNames.isEmpty()) {
            throw new IllegalArgumentException("Unknown zen hosts providers " + missingProviderNames);
        }
        List filteredHostsProviders = hostsProviderNames.stream().map(hostProviders::get).map(Supplier::get).collect(Collectors.toList());
        UnicastHostsProvider hostsProvider = hostsResolver -> {
            ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>();
            for (UnicastHostsProvider provider : filteredHostsProviders) {
                addresses.addAll(provider.buildDynamicHosts(hostsResolver));
            }
            return Collections.unmodifiableList(addresses);
        };
        HashMap<String, Supplier<Discovery>> discoveryTypes = new HashMap<String, Supplier<Discovery>>();
        discoveryTypes.put("zen", () -> new ZenDiscovery(settings, threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService, Collections.unmodifiableCollection(joinValidators)));
        discoveryTypes.put("single-node", () -> new SingleNodeDiscovery(settings, transportService, masterService, clusterApplier));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getDiscoveryTypes(threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService).entrySet().forEach(entry -> {
                if (discoveryTypes.put((String)entry.getKey(), (Supplier)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register discovery type [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        Supplier discoverySupplier = (Supplier)discoveryTypes.get(discoveryType);
        if (discoverySupplier == null) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        logger.info("using discovery type [{}] and host providers {}", (Object)discoveryType, (Object)hostsProviderNames);
        this.discovery = Objects.requireNonNull((Discovery)discoverySupplier.get());
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

