/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.gateway;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.logging.log4j.Logger;
import conductor.org.apache.logging.log4j.message.ParameterizedMessage;
import conductor.org.apache.lucene.codecs.CodecUtil;
import conductor.org.apache.lucene.store.Directory;
import conductor.org.apache.lucene.store.OutputStreamIndexOutput;
import conductor.org.apache.lucene.store.SimpleFSDirectory;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.common.collect.Tuple;
import conductor.org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import conductor.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import conductor.org.elasticsearch.common.xcontent.XContentBuilder;
import conductor.org.elasticsearch.common.xcontent.XContentFactory;
import conductor.org.elasticsearch.common.xcontent.XContentParser;
import conductor.org.elasticsearch.common.xcontent.XContentType;
import conductor.org.elasticsearch.core.internal.io.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class MetaDataStateFormat<T> {
    public static final XContentType FORMAT = XContentType.SMILE;
    public static final String STATE_DIR_NAME = "_state";
    public static final String STATE_FILE_EXTENSION = ".st";
    private static final String STATE_FILE_CODEC = "state";
    private static final int MIN_COMPATIBLE_STATE_FILE_VERSION = 1;
    private static final int STATE_FILE_VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final String prefix;
    private final Pattern stateFilePattern;
    private static final Logger logger = LogManager.getLogger(MetaDataStateFormat.class);

    protected MetaDataStateFormat(String prefix) {
        this.prefix = prefix;
        this.stateFilePattern = Pattern.compile(Pattern.quote(prefix) + "(\\d+)(" + STATE_FILE_EXTENSION + ")?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(T state, Path ... locations) throws IOException {
        if (locations == null) {
            throw new IllegalArgumentException("Locations must not be null");
        }
        if (locations.length <= 0) {
            throw new IllegalArgumentException("One or more locations required");
        }
        long maxStateId = this.findMaxStateId(this.prefix, locations) + 1L;
        assert (maxStateId >= 0L) : "maxStateId must be positive but was: [" + maxStateId + "]";
        String fileName = this.prefix + maxStateId + STATE_FILE_EXTENSION;
        Path stateLocation = locations[0].resolve(STATE_DIR_NAME);
        Files.createDirectories(stateLocation, new FileAttribute[0]);
        Path tmpStatePath = stateLocation.resolve(fileName + ".tmp");
        Path finalStatePath = stateLocation.resolve(fileName);
        try {
            String resourceDesc = "MetaDataStateFormat.write(path=\"" + tmpStatePath + "\")";
            try (OutputStreamIndexOutput out = new OutputStreamIndexOutput(resourceDesc, fileName, Files.newOutputStream(tmpStatePath, new OpenOption[0]), 4096);){
                CodecUtil.writeHeader(out, STATE_FILE_CODEC, 1);
                out.writeInt(FORMAT.index());
                try (XContentBuilder builder = this.newXContentBuilder(FORMAT, new IndexOutputOutputStream(out){

                    @Override
                    public void close() throws IOException {
                    }
                });){
                    builder.startObject();
                    this.toXContent(builder, state);
                    builder.endObject();
                }
                CodecUtil.writeFooter(out);
            }
            IOUtils.fsync(tmpStatePath, false);
            Files.move(tmpStatePath, finalStatePath, StandardCopyOption.ATOMIC_MOVE);
            IOUtils.fsync(stateLocation, true);
            logger.trace("written state to {}", (Object)finalStatePath);
            for (int i = 1; i < locations.length; ++i) {
                stateLocation = locations[i].resolve(STATE_DIR_NAME);
                Files.createDirectories(stateLocation, new FileAttribute[0]);
                Path tmpPath = stateLocation.resolve(fileName + ".tmp");
                Path finalPath = stateLocation.resolve(fileName);
                try {
                    Files.copy(finalStatePath, tmpPath, new CopyOption[0]);
                    IOUtils.fsync(tmpPath, false);
                    Files.move(tmpPath, finalPath, StandardCopyOption.ATOMIC_MOVE);
                    IOUtils.fsync(stateLocation, true);
                    logger.trace("copied state to {}", (Object)finalPath);
                    continue;
                }
                finally {
                    Files.deleteIfExists(tmpPath);
                    logger.trace("cleaned up {}", (Object)tmpPath);
                }
            }
        }
        finally {
            Files.deleteIfExists(tmpStatePath);
            logger.trace("cleaned up {}", (Object)tmpStatePath);
        }
        this.cleanupOldFiles(this.prefix, fileName, locations);
    }

    protected XContentBuilder newXContentBuilder(XContentType type, OutputStream stream) throws IOException {
        return XContentFactory.contentBuilder(type, stream);
    }

    public abstract void toXContent(XContentBuilder var1, T var2) throws IOException;

    public abstract T fromXContent(XContentParser var1) throws IOException;

    /*
     * Exception decompiling
     */
    public final T read(NamedXContentRegistry namedXContentRegistry, Path file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Directory newDirectory(Path dir) throws IOException {
        return new SimpleFSDirectory(dir);
    }

    private void cleanupOldFiles(String prefix, String currentStateFile, Path[] locations) throws IOException {
        DirectoryStream.Filter<Path> filter = entry -> {
            String entryFileName = entry.getFileName().toString();
            return Files.isRegularFile(entry, new LinkOption[0]) && entryFileName.startsWith(prefix) && !currentStateFile.equals(entryFileName);
        };
        for (Path dataLocation : locations) {
            logger.trace("cleanupOldFiles: cleaning up {}", (Object)dataLocation);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dataLocation.resolve(STATE_DIR_NAME), filter);){
                for (Path stateFile : stream) {
                    Files.deleteIfExists(stateFile);
                    logger.trace("cleanupOldFiles: cleaned up {}", (Object)stateFile);
                }
            }
        }
    }

    long findMaxStateId(String prefix, Path ... locations) throws IOException {
        long maxId = -1L;
        for (Path dataLocation : locations) {
            Path resolve = dataLocation.resolve(STATE_DIR_NAME);
            if (!Files.exists(resolve, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(resolve, prefix + "*");){
                for (Path stateFile : stream) {
                    Matcher matcher = this.stateFilePattern.matcher(stateFile.getFileName().toString());
                    if (!matcher.matches()) continue;
                    long id = Long.parseLong(matcher.group(1));
                    maxId = Math.max(maxId, id);
                }
            }
        }
        return maxId;
    }

    public Tuple<T, Long> loadLatestStateWithGeneration(Logger logger, NamedXContentRegistry namedXContentRegistry, Path ... dataLocations) throws IOException {
        ArrayList<PathAndStateId> files = new ArrayList<PathAndStateId>();
        long maxStateId = -1L;
        if (dataLocations != null) {
            for (Path dataLocation : dataLocations) {
                Path stateDir = dataLocation.resolve(STATE_DIR_NAME);
                try (DirectoryStream<Path> paths2 = Files.newDirectoryStream(stateDir);){
                    for (Path stateFile : paths2) {
                        Matcher matcher = this.stateFilePattern.matcher(stateFile.getFileName().toString());
                        if (!matcher.matches()) continue;
                        long stateId = Long.parseLong(matcher.group(1));
                        maxStateId = Math.max(maxStateId, stateId);
                        PathAndStateId pav = new PathAndStateId(stateFile, stateId);
                        logger.trace("found state file: {}", (Object)pav);
                        files.add(pav);
                    }
                }
                catch (FileNotFoundException | NoSuchFileException paths2) {
                    // empty catch block
                }
            }
        }
        long finalMaxStateId = maxStateId;
        Collection pathAndStateIds = files.stream().filter(pathAndStateId -> pathAndStateId.id == finalMaxStateId).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (PathAndStateId pathAndStateId2 : pathAndStateIds) {
            try {
                T state = this.read(namedXContentRegistry, pathAndStateId2.file);
                logger.trace("state id [{}] read from [{}]", (Object)pathAndStateId2.id, (Object)pathAndStateId2.file.getFileName());
                return Tuple.tuple(state, pathAndStateId2.id);
            }
            catch (Exception e) {
                exceptions.add(new IOException("failed to read " + pathAndStateId2.toString(), e));
                logger.debug(() -> new ParameterizedMessage("{}: failed to read [{}], ignoring...", (Object)pathAndStateId.file, (Object)this.prefix), (Throwable)e);
            }
        }
        ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        if (files.size() > 0) {
            throw new IllegalStateException("Could not find a state file to recover from among " + files);
        }
        return null;
    }

    public T loadLatestState(Logger logger, NamedXContentRegistry namedXContentRegistry, Path ... dataLocations) throws IOException {
        Tuple<T, Long> maybeLatestStateWithGeneration = this.loadLatestStateWithGeneration(logger, namedXContentRegistry, dataLocations);
        if (maybeLatestStateWithGeneration == null) {
            return null;
        }
        return maybeLatestStateWithGeneration.v1();
    }

    public static void deleteMetaState(Path ... dataLocations) throws IOException {
        Path[] stateDirectories = new Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            stateDirectories[i] = dataLocations[i].resolve(STATE_DIR_NAME);
        }
        IOUtils.rm(stateDirectories);
    }

    private static class PathAndStateId {
        final Path file;
        final long id;

        private PathAndStateId(Path file, long id) {
            this.file = file;
            this.id = id;
        }

        public String toString() {
            return "[id:" + this.id + ", file:" + this.file + "]";
        }
    }
}

