/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.http.netty4;

import conductor.io.netty.buffer.Unpooled;
import conductor.io.netty.channel.Channel;
import conductor.io.netty.channel.ChannelHandler;
import conductor.io.netty.channel.ChannelHandlerContext;
import conductor.io.netty.channel.SimpleChannelInboundHandler;
import conductor.io.netty.handler.codec.http.DefaultFullHttpRequest;
import conductor.io.netty.handler.codec.http.DefaultHttpHeaders;
import conductor.io.netty.handler.codec.http.FullHttpRequest;
import conductor.io.netty.handler.codec.http.HttpHeaders;
import conductor.org.elasticsearch.ExceptionsHelper;
import conductor.org.elasticsearch.common.util.concurrent.ThreadContext;
import conductor.org.elasticsearch.http.netty4.Netty4HttpChannel;
import conductor.org.elasticsearch.http.netty4.Netty4HttpRequest;
import conductor.org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import conductor.org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import conductor.org.elasticsearch.rest.RestRequest;
import java.util.Collections;

@ChannelHandler.Sharable
class Netty4HttpRequestHandler
extends SimpleChannelInboundHandler<Object> {
    private final Netty4HttpServerTransport serverTransport;
    private final boolean httpPipeliningEnabled;
    private final boolean detailedErrorsEnabled;
    private final ThreadContext threadContext;

    Netty4HttpRequestHandler(Netty4HttpServerTransport serverTransport, boolean detailedErrorsEnabled, ThreadContext threadContext) {
        this.serverTransport = serverTransport;
        this.httpPipeliningEnabled = serverTransport.pipelining;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.threadContext = threadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest request;
        HttpPipelinedRequest pipelinedRequest;
        if (this.httpPipeliningEnabled && msg instanceof HttpPipelinedRequest) {
            pipelinedRequest = (HttpPipelinedRequest)msg;
            request = (FullHttpRequest)pipelinedRequest.last();
        } else {
            pipelinedRequest = null;
            request = (FullHttpRequest)msg;
        }
        boolean success = false;
        try {
            Netty4HttpChannel innerChannel;
            Netty4HttpRequest innerHttpRequest;
            DefaultFullHttpRequest copy = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), Unpooled.copiedBuffer(request.content()), request.headers(), request.trailingHeaders());
            RuntimeException badRequestCause = null;
            try {
                innerHttpRequest = new Netty4HttpRequest(this.serverTransport.xContentRegistry, copy, ctx.channel());
            }
            catch (RestRequest.ContentTypeHeaderException e) {
                badRequestCause = e;
                innerHttpRequest = this.requestWithoutContentTypeHeader(copy, ctx.channel(), badRequestCause);
            }
            catch (RestRequest.BadParameterException e) {
                badRequestCause = e;
                innerHttpRequest = this.requestWithoutParameters(copy, ctx.channel());
            }
            Netty4HttpRequest httpRequest = innerHttpRequest;
            try {
                innerChannel = new Netty4HttpChannel(this.serverTransport, httpRequest, pipelinedRequest, this.detailedErrorsEnabled, this.threadContext);
            }
            catch (IllegalArgumentException e) {
                if (badRequestCause == null) {
                    badRequestCause = e;
                } else {
                    badRequestCause.addSuppressed(e);
                }
                Netty4HttpRequest innerRequest = new Netty4HttpRequest(this.serverTransport.xContentRegistry, Collections.emptyMap(), copy.uri(), copy, ctx.channel());
                innerChannel = new Netty4HttpChannel(this.serverTransport, innerRequest, pipelinedRequest, this.detailedErrorsEnabled, this.threadContext);
            }
            Netty4HttpChannel channel = innerChannel;
            if (request.decoderResult().isFailure()) {
                this.serverTransport.dispatchBadRequest(httpRequest, channel, request.decoderResult().cause());
            } else if (badRequestCause != null) {
                this.serverTransport.dispatchBadRequest(httpRequest, channel, badRequestCause);
            } else {
                this.serverTransport.dispatchRequest(httpRequest, channel);
            }
            success = true;
        }
        finally {
            if (!success && pipelinedRequest != null) {
                pipelinedRequest.release();
            }
        }
    }

    private Netty4HttpRequest requestWithoutContentTypeHeader(FullHttpRequest request, Channel channel, Exception badRequestCause) {
        DefaultHttpHeaders headersWithoutContentTypeHeader = new DefaultHttpHeaders();
        ((HttpHeaders)headersWithoutContentTypeHeader).add(request.headers());
        ((HttpHeaders)headersWithoutContentTypeHeader).remove("Content-Type");
        DefaultFullHttpRequest requestWithoutContentTypeHeader = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), request.content(), headersWithoutContentTypeHeader, request.trailingHeaders());
        try {
            return new Netty4HttpRequest(this.serverTransport.xContentRegistry, requestWithoutContentTypeHeader, channel);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause.addSuppressed(e);
            return this.requestWithoutParameters(requestWithoutContentTypeHeader, channel);
        }
    }

    private Netty4HttpRequest requestWithoutParameters(FullHttpRequest request, Channel channel) {
        return new Netty4HttpRequest(this.serverTransport.xContentRegistry, Collections.emptyMap(), request.uri(), request, channel);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ExceptionsHelper.maybeDieOnAnotherThread(cause);
        this.serverTransport.exceptionCaught(ctx, cause);
    }
}

