/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.analysis;

import conductor.org.apache.logging.log4j.LogManager;
import conductor.org.apache.lucene.analysis.TokenStream;
import conductor.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import conductor.org.apache.lucene.analysis.shingle.ShingleFilter;
import conductor.org.elasticsearch.common.logging.DeprecationLogger;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.env.Environment;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import conductor.org.elasticsearch.index.analysis.TokenFilterFactory;

public class ShingleTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ShingleTokenFilterFactory.class));
    private final Factory factory;

    public ShingleTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        int maxAllowedShingleDiff = indexSettings.getMaxShingleDiff();
        Integer maxShingleSize = settings.getAsInt("max_shingle_size", 2);
        Integer minShingleSize = settings.getAsInt("min_shingle_size", 2);
        Boolean outputUnigrams = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "output_unigrams", true, this.deprecationLogger);
        Boolean outputUnigramsIfNoShingles = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "output_unigrams_if_no_shingles", false, this.deprecationLogger);
        int shingleDiff = maxShingleSize - minShingleSize + (outputUnigrams != false ? 1 : 0);
        if (shingleDiff > maxAllowedShingleDiff) {
            this.deprecationLogger.deprecated("Deprecated big difference between maxShingleSize and minShingleSize in Shingle TokenFilter,expected difference must be less than or equal to: [" + maxAllowedShingleDiff + "]", new Object[0]);
        }
        String tokenSeparator = settings.get("token_separator", " ");
        String fillerToken = settings.get("filler_token", "_");
        this.factory = new Factory("shingle", minShingleSize, maxShingleSize, outputUnigrams, outputUnigramsIfNoShingles, tokenSeparator, fillerToken);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return this.factory.create(tokenStream);
    }

    @Override
    public TokenFilterFactory getSynonymFilter() {
        DEPRECATION_LOGGER.deprecatedAndMaybeLog("synonym_tokenfilters", "Token filter [" + this.name() + "] will not be usable to parse synonyms after v7.0", new Object[0]);
        return this;
    }

    public Factory getInnerFactory() {
        return this.factory;
    }

    public static final class Factory
    implements TokenFilterFactory {
        private final int maxShingleSize;
        private final boolean outputUnigrams;
        private final boolean outputUnigramsIfNoShingles;
        private final String tokenSeparator;
        private final String fillerToken;
        private int minShingleSize;
        private final String name;

        public Factory(String name) {
            this(name, 2, 2, true, false, " ", "_");
        }

        Factory(String name, int minShingleSize, int maxShingleSize, boolean outputUnigrams, boolean outputUnigramsIfNoShingles, String tokenSeparator, String fillerToken) {
            this.maxShingleSize = maxShingleSize;
            this.outputUnigrams = outputUnigrams;
            this.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
            this.tokenSeparator = tokenSeparator;
            this.minShingleSize = minShingleSize;
            this.fillerToken = fillerToken;
            this.name = name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            ShingleFilter filter = new ShingleFilter(tokenStream, this.minShingleSize, this.maxShingleSize);
            filter.setOutputUnigrams(this.outputUnigrams);
            filter.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
            filter.setTokenSeparator(this.tokenSeparator);
            filter.setFillerToken(this.fillerToken);
            if (this.outputUnigrams || this.minShingleSize != this.maxShingleSize) {
                filter.addAttribute(DisableGraphAttribute.class);
            }
            return filter;
        }

        public int getMaxShingleSize() {
            return this.maxShingleSize;
        }

        public int getMinShingleSize() {
            return this.minShingleSize;
        }

        public boolean getOutputUnigrams() {
            return this.outputUnigrams;
        }

        public boolean getOutputUnigramsIfNoShingles() {
            return this.outputUnigramsIfNoShingles;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

