/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.engine;

import conductor.org.apache.lucene.index.IndexReader;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.SegmentReader;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.SearcherFactory;
import conductor.org.elasticsearch.common.breaker.CircuitBreaker;
import conductor.org.elasticsearch.common.lucene.Lucene;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class RamAccountingSearcherFactory
extends SearcherFactory {
    private final CircuitBreakerService breakerService;

    RamAccountingSearcherFactory(CircuitBreakerService breakerService) {
        this.breakerService = breakerService;
    }

    @Override
    public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
        this.processReaders(reader, previousReader);
        return super.newSearcher(reader, previousReader);
    }

    public void processReaders(IndexReader reader, IndexReader previousReader) {
        Set prevReaders;
        CircuitBreaker breaker = this.breakerService.getBreaker("accounting");
        if (previousReader == null) {
            prevReaders = Collections.emptySet();
        } else {
            List<LeafReaderContext> previousReaderLeaves = previousReader.leaves();
            prevReaders = new HashSet(previousReaderLeaves.size());
            for (LeafReaderContext lrc : previousReaderLeaves) {
                prevReaders.add(Lucene.segmentReader(lrc.reader()).getCoreCacheHelper().getKey());
            }
        }
        for (LeafReaderContext lrc : reader.leaves()) {
            SegmentReader segmentReader = Lucene.segmentReader(lrc.reader());
            if (prevReaders.contains(segmentReader.getCoreCacheHelper().getKey())) continue;
            long ramBytesUsed = segmentReader.ramBytesUsed();
            breaker.addWithoutBreaking(ramBytesUsed);
            segmentReader.getCoreCacheHelper().addClosedListener(k -> breaker.addWithoutBreaking(-ramBytesUsed));
        }
    }
}

