/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata;

import conductor.org.apache.lucene.index.DirectoryReader;
import conductor.org.apache.lucene.index.IndexReaderContext;
import conductor.org.apache.lucene.index.LeafReaderContext;
import conductor.org.apache.lucene.index.ReaderUtil;
import conductor.org.apache.lucene.search.DocIdSetIterator;
import conductor.org.apache.lucene.search.FieldComparatorSource;
import conductor.org.apache.lucene.search.IndexSearcher;
import conductor.org.apache.lucene.search.Query;
import conductor.org.apache.lucene.search.Scorer;
import conductor.org.apache.lucene.search.SortField;
import conductor.org.apache.lucene.search.Weight;
import conductor.org.apache.lucene.search.join.BitSetProducer;
import conductor.org.apache.lucene.util.BitSet;
import conductor.org.apache.lucene.util.BytesRef;
import conductor.org.elasticsearch.common.Nullable;
import conductor.org.elasticsearch.index.IndexComponent;
import conductor.org.elasticsearch.index.IndexSettings;
import conductor.org.elasticsearch.index.fielddata.AtomicFieldData;
import conductor.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.MapperService;
import conductor.org.elasticsearch.indices.breaker.CircuitBreakerService;
import conductor.org.elasticsearch.search.MultiValueMode;
import conductor.org.elasticsearch.search.sort.NestedSortBuilder;
import java.io.IOException;
import java.util.function.Function;

public interface IndexFieldData<FD extends AtomicFieldData>
extends IndexComponent {
    public String getFieldName();

    public FD load(LeafReaderContext var1);

    public FD loadDirect(LeafReaderContext var1) throws Exception;

    public SortField sortField(@Nullable Object var1, MultiValueMode var2, XFieldComparatorSource.Nested var3, boolean var4);

    public void clear();

    public static interface Global<FD extends AtomicFieldData>
    extends IndexFieldData<FD> {
        public IndexFieldData<FD> loadGlobal(DirectoryReader var1);

        public IndexFieldData<FD> localGlobalDirect(DirectoryReader var1) throws Exception;
    }

    public static interface Builder {
        public IndexFieldData<?> build(IndexSettings var1, MappedFieldType var2, IndexFieldDataCache var3, CircuitBreakerService var4, MapperService var5);
    }

    public static abstract class XFieldComparatorSource
    extends FieldComparatorSource {
        protected final MultiValueMode sortMode;
        protected final Object missingValue;
        protected final Nested nested;

        public XFieldComparatorSource(Object missingValue, MultiValueMode sortMode, Nested nested) {
            this.sortMode = sortMode;
            this.missingValue = missingValue;
            this.nested = nested;
        }

        public MultiValueMode sortMode() {
            return this.sortMode;
        }

        public Nested nested() {
            return this.nested;
        }

        public final boolean sortMissingFirst(Object missingValue) {
            return "_first".equals(missingValue);
        }

        public final boolean sortMissingLast(Object missingValue) {
            return missingValue == null || "_last".equals(missingValue);
        }

        public final Object missingObject(Object missingValue, boolean reversed) {
            if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
                boolean min = this.sortMissingFirst(missingValue) ^ reversed;
                switch (this.reducedType()) {
                    case INT: {
                        return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    }
                    case LONG: {
                        return min ? Long.MIN_VALUE : Long.MAX_VALUE;
                    }
                    case FLOAT: {
                        return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                    }
                    case DOUBLE: {
                        return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    case STRING: 
                    case STRING_VAL: {
                        return null;
                    }
                }
                throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
            }
            switch (this.reducedType()) {
                case INT: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).intValue();
                    }
                    return Integer.parseInt(missingValue.toString());
                }
                case LONG: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).longValue();
                    }
                    return Long.parseLong(missingValue.toString());
                }
                case FLOAT: {
                    if (missingValue instanceof Number) {
                        return Float.valueOf(((Number)missingValue).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(missingValue.toString()));
                }
                case DOUBLE: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).doubleValue();
                    }
                    return Double.parseDouble(missingValue.toString());
                }
                case STRING: 
                case STRING_VAL: {
                    if (missingValue instanceof BytesRef) {
                        return (BytesRef)missingValue;
                    }
                    if (missingValue instanceof byte[]) {
                        return new BytesRef((byte[])missingValue);
                    }
                    return new BytesRef(missingValue.toString());
                }
            }
            throw new UnsupportedOperationException("Unsupported reduced type: " + (Object)((Object)this.reducedType()));
        }

        public abstract SortField.Type reducedType();

        public Object missingValue(boolean reversed) {
            return null;
        }

        public static class Nested {
            private final BitSetProducer rootFilter;
            private final Query innerQuery;
            private final NestedSortBuilder nestedSort;
            private final Function<IndexReaderContext, IndexSearcher> searcherFactory;

            public Nested(BitSetProducer rootFilter, Query innerQuery, NestedSortBuilder nestedSort, Function<IndexReaderContext, IndexSearcher> searcherFactory) {
                this.rootFilter = rootFilter;
                this.innerQuery = innerQuery;
                this.nestedSort = nestedSort;
                this.searcherFactory = searcherFactory;
            }

            public Query getInnerQuery() {
                return this.innerQuery;
            }

            public BitSetProducer getRootFilter() {
                return this.rootFilter;
            }

            public NestedSortBuilder getNestedSort() {
                return this.nestedSort;
            }

            public BitSet rootDocs(LeafReaderContext ctx) throws IOException {
                return this.rootFilter.getBitSet(ctx);
            }

            public DocIdSetIterator innerDocs(LeafReaderContext ctx) throws IOException {
                IndexReaderContext topLevelCtx = ReaderUtil.getTopLevelContext(ctx);
                IndexSearcher indexSearcher = this.searcherFactory.apply(topLevelCtx);
                Weight weight = indexSearcher.createNormalizedWeight(this.innerQuery, false);
                Scorer s = weight.scorer(ctx);
                return s == null ? null : s.iterator();
            }
        }
    }
}

