/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.fielddata.plain;

import conductor.org.apache.lucene.index.BinaryDocValues;
import conductor.org.apache.lucene.index.DocValues;
import conductor.org.apache.lucene.index.LeafReader;
import conductor.org.apache.lucene.util.Accountable;
import conductor.org.elasticsearch.index.fielddata.AtomicFieldData;
import conductor.org.elasticsearch.index.fielddata.FieldData;
import conductor.org.elasticsearch.index.fielddata.ScriptDocValues;
import conductor.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class BinaryDVAtomicFieldData
implements AtomicFieldData {
    private final LeafReader reader;
    private final String field;

    public BinaryDVAtomicFieldData(LeafReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        try {
            BinaryDocValues values = DocValues.getBinary(this.reader, this.field);
            return FieldData.singleton(values);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    @Override
    public void close() {
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }
}

