/*
 * Decompiled with CFR 0.152.
 */
package conductor.org.elasticsearch.index.mapper;

import conductor.org.apache.lucene.document.Field;
import conductor.org.apache.lucene.document.LatLonShape;
import conductor.org.apache.lucene.geo.Line;
import conductor.org.apache.lucene.geo.Polygon;
import conductor.org.apache.lucene.geo.Rectangle;
import conductor.org.apache.lucene.index.IndexableField;
import conductor.org.elasticsearch.common.Explicit;
import conductor.org.elasticsearch.common.geo.GeoPoint;
import conductor.org.elasticsearch.common.geo.builders.ShapeBuilder;
import conductor.org.elasticsearch.common.geo.parsers.ShapeParser;
import conductor.org.elasticsearch.common.settings.Settings;
import conductor.org.elasticsearch.index.mapper.BaseGeoShapeFieldMapper;
import conductor.org.elasticsearch.index.mapper.FieldMapper;
import conductor.org.elasticsearch.index.mapper.MappedFieldType;
import conductor.org.elasticsearch.index.mapper.Mapper;
import conductor.org.elasticsearch.index.mapper.MapperParsingException;
import conductor.org.elasticsearch.index.mapper.ParseContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class GeoShapeFieldMapper
extends BaseGeoShapeFieldMapper {
    public GeoShapeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, ignoreZValue, indexSettings, multiFields, copyTo);
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        try {
            Object shape = context.parseExternalValue(Object.class);
            if (shape == null) {
                ShapeBuilder shapeBuilder = ShapeParser.parse(context.parser(), this);
                if (shapeBuilder == null) {
                    return;
                }
                shape = shapeBuilder.buildLucene();
            }
            this.indexShape(context, shape);
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(this.fieldType().name());
        }
    }

    private void indexShape(ParseContext context, Object luceneShape) {
        if (luceneShape instanceof GeoPoint) {
            GeoPoint pt = (GeoPoint)luceneShape;
            this.indexFields(context, LatLonShape.createIndexableFields(this.name(), pt.lat(), pt.lon()));
        } else if (luceneShape instanceof double[]) {
            double[] pt = (double[])luceneShape;
            this.indexFields(context, LatLonShape.createIndexableFields(this.name(), pt[1], pt[0]));
        } else if (luceneShape instanceof Line) {
            this.indexFields(context, LatLonShape.createIndexableFields(this.name(), (Line)luceneShape));
        } else if (luceneShape instanceof Polygon) {
            this.indexFields(context, LatLonShape.createIndexableFields(this.name(), (Polygon)luceneShape));
        } else if (luceneShape instanceof double[][]) {
            double[][] pts = (double[][])luceneShape;
            for (int i = 0; i < pts.length; ++i) {
                this.indexFields(context, LatLonShape.createIndexableFields(this.name(), pts[i][1], pts[i][0]));
            }
        } else if (luceneShape instanceof Line[]) {
            Line[] lines = (Line[])luceneShape;
            for (int i = 0; i < lines.length; ++i) {
                this.indexFields(context, LatLonShape.createIndexableFields(this.name(), lines[i]));
            }
        } else if (luceneShape instanceof Polygon[]) {
            Polygon[] polys = (Polygon[])luceneShape;
            for (int i = 0; i < polys.length; ++i) {
                this.indexFields(context, LatLonShape.createIndexableFields(this.name(), polys[i]));
            }
        } else if (luceneShape instanceof Rectangle) {
            Rectangle r = (Rectangle)luceneShape;
            Polygon p = new Polygon(new double[]{r.minLat, r.minLat, r.maxLat, r.maxLat, r.minLat}, new double[]{r.minLon, r.maxLon, r.maxLon, r.minLon, r.minLon}, new Polygon[0]);
            this.indexFields(context, LatLonShape.createIndexableFields(this.name(), p));
        } else if (luceneShape instanceof Object[]) {
            for (Object o : (Object[])luceneShape) {
                this.indexShape(context, o);
            }
        } else {
            throw new IllegalArgumentException("invalid shape type found [" + luceneShape.getClass() + "] while indexing shape");
        }
    }

    private void indexFields(ParseContext context, Field[] fields) {
        ArrayList<IndexableField> flist = new ArrayList<IndexableField>(Arrays.asList(fields));
        this.createFieldNamesField(context, flist);
        for (IndexableField f : flist) {
            context.doc().add(f);
        }
    }

    public static final class GeoShapeFieldType
    extends BaseGeoShapeFieldMapper.BaseGeoShapeFieldType {
        public GeoShapeFieldType() {
        }

        protected GeoShapeFieldType(GeoShapeFieldType ref) {
            super(ref);
        }

        @Override
        public GeoShapeFieldType clone() {
            return new GeoShapeFieldType(this);
        }
    }

    public static class Builder
    extends BaseGeoShapeFieldMapper.Builder<BaseGeoShapeFieldMapper.Builder, GeoShapeFieldMapper> {
        public Builder(String name) {
            super(name, new GeoShapeFieldType(), new GeoShapeFieldType());
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new GeoShapeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.ignoreZValue(), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

